/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.database;

import me.dreamdevs.github.slender.SlenderMain;
import me.dreamdevs.github.slender.api.database.IData;
import me.dreamdevs.github.slender.game.GamePlayer;
import me.dreamdevs.github.slender.utils.Util;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Database {
    private IData connector;

    public void connect(String databaseType) {
        Class<IData> database = null;
        Util.sendPluginMessage("&aConnecting to database...");
        try {
            database = Class.forName("me.dreamdevs.github.slender.database.Database" + databaseType).asSubclass(IData.class);
            this.connector = database.newInstance();
            this.connector.connectDatabase();
            Util.sendPluginMessage("&aConnected to " + databaseType + " database.");
        }
        catch (Exception e) {
            Util.sendPluginMessage("&cDatabase type '" + databaseType + "' does not exist!");
        }
    }

    public void disconnect() {
        this.connector.disconnectDatabase();
        Util.sendPluginMessage("&aDisconnected from the database.");
    }

    public void autoSaveData() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)SlenderMain.getInstance(), () -> SlenderMain.getInstance().getPlayerManager().getPlayers().forEach(this::saveData), 0L, 6000L);
        Util.sendPluginMessage("&aData saved!");
    }

    public void saveData(GamePlayer gamePlayer) {
        this.connector.saveAllStatistics(gamePlayer);
    }

    public void loadData(GamePlayer gamePlayer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)SlenderMain.getInstance(), () -> this.connector.loadAllStatistics(gamePlayer));
    }

    public IData getConnector() {
        return this.connector;
    }
}

