/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.dreamdevs.github.slender.SlenderMain;
import me.dreamdevs.github.slender.commands.ArgumentCommand;
import me.dreamdevs.github.slender.commands.partyarguments.PartyAcceptInviteArgument;
import me.dreamdevs.github.slender.commands.partyarguments.PartyCreateArgument;
import me.dreamdevs.github.slender.commands.partyarguments.PartyDeleteArgument;
import me.dreamdevs.github.slender.commands.partyarguments.PartyInviteArgument;
import me.dreamdevs.github.slender.commands.partyarguments.PartyKickMemberArgument;
import me.dreamdevs.github.slender.commands.partyarguments.PartyLeaveArgument;
import me.dreamdevs.github.slender.utils.ColourUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

public class PartyCommandHandler
implements TabExecutor {
    private final HashMap<String, Class<? extends ArgumentCommand>> arguments = new HashMap();

    public PartyCommandHandler(SlenderMain plugin) {
        this.registerCommand("create", PartyCreateArgument.class);
        this.registerCommand("delete", PartyDeleteArgument.class);
        this.registerCommand("invite", PartyInviteArgument.class);
        this.registerCommand("kick", PartyKickMemberArgument.class);
        this.registerCommand("accept", PartyAcceptInviteArgument.class);
        this.registerCommand("leave", PartyLeaveArgument.class);
        plugin.getCommand("party").setExecutor((CommandExecutor)this);
        plugin.getCommand("party").setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        try {
            if (strings.length >= 1) {
                if (this.arguments.containsKey(strings[0])) {
                    Class<ArgumentCommand> argumentCommand = this.arguments.get(strings[0]).asSubclass(ArgumentCommand.class);
                    ArgumentCommand argument = argumentCommand.newInstance();
                    if (commandSender.hasPermission(argument.getPermission())) {
                        argument.execute(commandSender, strings);
                    } else {
                        commandSender.sendMessage(SlenderMain.getInstance().getMessagesManager().getMessage("no-permission"));
                    }
                    return true;
                }
                commandSender.sendMessage(SlenderMain.getInstance().getMessagesManager().getMessage("no-argument"));
                return true;
            }
            commandSender.sendMessage(ColourUtil.colorize("&aHelp for Stop It Slender Party:"));
            for (Class<? extends ArgumentCommand> argumentCommand : this.arguments.values()) {
                commandSender.sendMessage(ColourUtil.colorize(argumentCommand.newInstance().getHelpText()));
            }
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        ArrayList<String> completions = new ArrayList<String>();
        if (strings.length == 1) {
            StringUtil.copyPartialMatches((String)strings[0], this.arguments.keySet(), completions);
            Collections.sort(completions);
            return completions;
        }
        return Collections.emptyList();
    }

    public void registerCommand(String command, Class<? extends ArgumentCommand> clazz) {
        this.arguments.put(command, clazz);
    }

    public HashMap<String, Class<? extends ArgumentCommand>> getArguments() {
        return this.arguments;
    }
}

