/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.api.menu;

import java.util.List;
import me.dreamdevs.github.slender.api.events.ClickInventoryEvent;
import me.dreamdevs.github.slender.api.menu.ItemAction;
import me.dreamdevs.github.slender.utils.ColourUtil;
import me.dreamdevs.github.slender.utils.Util;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuItem {
    private String displayName;
    private List<String> lore;
    private Material material;
    private ItemStack itemStack;
    private ItemAction itemAction;

    public MenuItem name(String displayName) {
        this.displayName = ColourUtil.colorize(displayName);
        return this;
    }

    public MenuItem material(Material material) {
        this.material = material;
        return this;
    }

    public MenuItem lore(String ... lore) {
        this.lore = ColourUtil.colouredLore(lore);
        return this;
    }

    public MenuItem lore(List<String> lore) {
        this.lore = ColourUtil.colouredLore(lore);
        return this;
    }

    public MenuItem action(ItemAction action) {
        this.itemAction = action;
        return this;
    }

    public MenuItem build() {
        try {
            this.itemStack = new ItemStack(this.material);
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            if (this.displayName != null) {
                itemMeta.setDisplayName(this.displayName);
            }
            if (this.lore != null) {
                itemMeta.setLore(this.lore);
            }
            this.itemStack.setItemMeta(itemMeta);
        }
        catch (Exception e) {
            Util.sendPluginMessage("&cCouldn't build menu item, because there's missing material!");
        }
        return this;
    }

    public void performAction(ClickInventoryEvent event) {
        if (this.itemAction != null) {
            this.itemAction.action(event);
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

