/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.api.menu;

import java.util.Arrays;
import me.dreamdevs.github.slender.api.menu.MenuItem;
import me.dreamdevs.github.slender.listeners.InventoryListener;
import me.dreamdevs.github.slender.utils.ColourUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class Menu
implements InventoryHolder {
    private final String title;
    private final int rows;
    private final Inventory inventory;
    private MenuItem[] menuItems;

    public Menu(String title, int rows) {
        this.title = ColourUtil.colorize(title);
        this.rows = rows;
        if (rows > 6 || rows < 1) {
            rows = 3;
        }
        this.menuItems = new MenuItem[rows * 9];
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (String)this.title);
    }

    public void fillPanels() {
        Arrays.fill(this.menuItems, new MenuItem().material(Material.WHITE_STAINED_GLASS_PANE).name("&c&l*").build());
    }

    public void fill() {
        for (int x = 0; x < this.inventory.getSize(); ++x) {
            this.setItem(x, new MenuItem().material(Material.WHITE_STAINED_GLASS_PANE).name("&c&l*").build());
        }
    }

    public void setItem(int slot, MenuItem menuItem) {
        this.menuItems[slot] = menuItem;
    }

    public void addItem(MenuItem menuItem) {
        for (int x = 0; x < this.menuItems.length; ++x) {
            if (this.menuItems[x] != null) continue;
            this.menuItems[x] = menuItem;
            break;
        }
    }

    public void open(Player player) {
        this.inventory.clear();
        for (int x = 0; x < this.menuItems.length; ++x) {
            if (this.menuItems[x] == null) continue;
            this.inventory.setItem(x, this.menuItems[x].getItemStack());
        }
        InventoryListener.menus.put(player.getUniqueId(), this);
        player.openInventory(this.inventory);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public String getTitle() {
        return this.title;
    }

    public int getRows() {
        return this.rows;
    }

    public MenuItem[] getMenuItems() {
        return this.menuItems;
    }
}

