/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender;

import me.dreamdevs.github.slender.Metrics;
import me.dreamdevs.github.slender.UpdateChecker;
import me.dreamdevs.github.slender.commands.CommandHandler;
import me.dreamdevs.github.slender.commands.PartyCommandHandler;
import me.dreamdevs.github.slender.database.Database;
import me.dreamdevs.github.slender.game.GamePlayer;
import me.dreamdevs.github.slender.game.Lobby;
import me.dreamdevs.github.slender.listeners.GameListeners;
import me.dreamdevs.github.slender.listeners.InventoryListener;
import me.dreamdevs.github.slender.listeners.PerksListeners;
import me.dreamdevs.github.slender.listeners.PlayerInteractListener;
import me.dreamdevs.github.slender.listeners.PlayerListeners;
import me.dreamdevs.github.slender.managers.ConfigManager;
import me.dreamdevs.github.slender.managers.GameManager;
import me.dreamdevs.github.slender.managers.MessagesManager;
import me.dreamdevs.github.slender.managers.PartyManager;
import me.dreamdevs.github.slender.managers.PlayerManager;
import me.dreamdevs.github.slender.utils.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SlenderMain
extends JavaPlugin {
    private static SlenderMain instance;
    private ConfigManager configManager;
    private GameManager gameManager;
    private PlayerManager playerManager;
    private Lobby lobby;
    private MessagesManager messagesManager;
    private Database database;
    private PartyManager partyManager;
    private boolean useLibsDisguises = false;
    private boolean usePerks;
    private boolean useParties;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfigFiles("items.yml", "messages.yml", "perks.yml", "config.yml");
        this.database = new Database();
        this.database.connect("YAML");
        this.messagesManager = new MessagesManager(this);
        if (this.getServer().getPluginManager().getPlugin("LibsDisguises") != null) {
            this.useLibsDisguises = true;
            Util.sendPluginMessage("&aLibsDisguises detected!");
        } else {
            Util.sendPluginMessage("&cLibsDisguises did not detected!");
        }
        this.usePerks = this.getConfigManager().getConfig("perks.yml").getBoolean("Enabled");
        this.useParties = this.getConfigManager().getConfig("config.yml").getBoolean("use-parties");
        this.lobby = new Lobby();
        this.gameManager = new GameManager();
        this.playerManager = new PlayerManager();
        new CommandHandler(this);
        if (this.isUseParties()) {
            this.partyManager = new PartyManager();
            new PartyCommandHandler(this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerInteractListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GameListeners(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PerksListeners(), (Plugin)this);
        this.database.autoSaveData();
        new Metrics(this, 18471);
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> new UpdateChecker(this, 109730).getVersion(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                Util.sendPluginMessage("");
                Util.sendPluginMessage("&aYour version is up to date!");
                Util.sendPluginMessage("&aYour version: " + this.getDescription().getVersion());
                Util.sendPluginMessage("");
            } else {
                Util.sendPluginMessage("");
                Util.sendPluginMessage("&aThere is new Stop It Slender version!");
                Util.sendPluginMessage("&aYour version: " + this.getDescription().getVersion());
                Util.sendPluginMessage("&aNew version: " + version);
                Util.sendPluginMessage("");
            }
        }), 10L, 6000L);
    }

    public void onDisable() {
        Bukkit.getWorlds().forEach(world -> world.getEntities().stream().filter(Item.class::isInstance).forEach(Entity::remove));
        for (GamePlayer gamePlayer : this.getPlayerManager().getPlayers()) {
            this.database.saveData(gamePlayer);
        }
        this.database.disconnect();
        this.gameManager.saveGames();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public Lobby getLobby() {
        return this.lobby;
    }

    public MessagesManager getMessagesManager() {
        return this.messagesManager;
    }

    public Database getDatabase() {
        return this.database;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public boolean isUseLibsDisguises() {
        return this.useLibsDisguises;
    }

    public boolean isUsePerks() {
        return this.usePerks;
    }

    public boolean isUseParties() {
        return this.useParties;
    }

    public static SlenderMain getInstance() {
        return instance;
    }
}

