/*
 * Decompiled with CFR 0.152.
 */
package TesT;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MyPortalsCommands
extends JavaPlugin
implements Listener {
    private FileConfiguration messages;
    HashMap<UUID, List<String>> playersPortalsIn = new HashMap();
    HashMap<UUID, Location> pos1 = new HashMap();
    HashMap<UUID, Location> pos2 = new HashMap();

    public void onEnable() {
        this.reload();
        this.saveResource("messages.yml", false);
        this.messages = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "messages.yml"));
        this.getCommand("myportalscommands").setExecutor((CommandExecutor)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void reload() {
        this.reloadConfig();
        if (this.getConfig().get("portals") == null) {
            this.getConfig().createSection("portals");
        }
        this.saveConfig();
        this.reloadConfig();
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        try {
            this.messages.save(messagesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ItemStack getWand() {
        ItemStack wand = new ItemStack(Material.STICK);
        ItemMeta wandMeta = wand.getItemMeta();
        wandMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aMyPortalsCommands Wand"));
        wand.setItemMeta(wandMeta);
        return wand;
    }

    public boolean isInArea(Location location, Location pos1, Location pos2) {
        return location.getWorld().getName().equals(pos1.getWorld().getName()) && location.getBlockX() >= Math.min(pos1.getBlockX(), pos2.getBlockX()) && location.getBlockX() <= Math.max(pos1.getBlockX(), pos2.getBlockX()) && location.getBlockY() >= Math.min(pos1.getBlockY(), pos2.getBlockY()) && location.getBlockY() <= Math.max(pos1.getBlockY(), pos2.getBlockY()) && location.getBlockZ() >= Math.min(pos1.getBlockZ(), pos2.getBlockZ()) && location.getBlockZ() <= Math.max(pos1.getBlockZ(), pos2.getBlockZ());
    }

    public String locationToString(Location location, Boolean isBlock) {
        if (isBlock.booleanValue()) {
            return String.valueOf(location.getWorld().getName()) + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
        }
        return String.valueOf(location.getWorld().getName()) + "," + location.getX() + "," + location.getY() + "," + location.getZ() + "," + location.getYaw() + "," + location.getPitch();
    }

    public Location stringToLocation(String location_string) {
        String[] location_split = location_string.split(",");
        if (location_split.length > 4) {
            return new Location(Bukkit.getWorld((String)location_split[0]), Double.parseDouble(location_split[1]), Double.parseDouble(location_split[2]), Double.parseDouble(location_split[3]), Float.parseFloat(location_split[4]), Float.parseFloat(location_split[5]));
        }
        return new Location(Bukkit.getWorld((String)location_split[0]), Double.parseDouble(location_split[1]), Double.parseDouble(location_split[2]), Double.parseDouble(location_split[3]));
    }

    public static boolean isDigit(String digit) {
        try {
            Integer.parseInt(digit);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("myportalscommands.admin")) {
            if (args.length == 0) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eMyPortalsCommands"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands reload"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands wand"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands portals"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands setportal <name>"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands commands <name> <add/list/remove> [command/position command]"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands deleteportal <name>"));
            } else {
                if (args[0].equalsIgnoreCase("portals")) {
                    ConfigurationSection portals = this.getConfig().getConfigurationSection("portals");
                    if (portals == null) {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("noPortalsFound")));
                        return true;
                    }
                    Set portalNames = portals.getKeys(false);
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("portalsList")));
                    for (String portalName : portalNames) {
                        Location pos1 = this.stringToLocation(this.getConfig().getString("portals." + portalName + ".pos1"));
                        Location pos2 = this.stringToLocation(this.getConfig().getString("portals." + portalName + ".pos2"));
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6" + portalName + " | &fPos1 " + pos1.getBlockX() + ", " + pos1.getBlockY() + ", " + pos1.getBlockZ() + " &6| &fPos2 " + pos2.getBlockX() + ", " + pos2.getBlockY() + ", " + pos2.getBlockZ())));
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("reload")) {
                    this.reload();
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("reloadedConfig")));
                } else if (args[0].equalsIgnoreCase("wand")) {
                    if (sender instanceof Player) {
                        Player p = (Player)sender;
                        p.getInventory().addItem(new ItemStack[]{this.getWand()});
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("receivedWand")));
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("consoleCannotExecute")));
                    }
                } else if (args[0].equalsIgnoreCase("setportal")) {
                    if (args.length > 1) {
                        String portalName = args[1];
                        if (sender instanceof Player) {
                            Player p = (Player)sender;
                            if (this.pos1.containsKey(p.getUniqueId()) && this.pos2.containsKey(p.getUniqueId()) && this.pos1.get(p.getUniqueId()).getWorld().equals(this.pos2.get(p.getUniqueId()).getWorld())) {
                                if (this.getConfig().get("portals." + portalName) != null) {
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("portalAlreadyExists")));
                                    return true;
                                }
                                String permissionName = "myportalscommands.portal." + portalName;
                                Permission portalPermission = Bukkit.getServer().getPluginManager().getPermission(permissionName);
                                if (portalPermission != null) {
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("portalPermissionExists")));
                                    return true;
                                }
                                portalPermission = new Permission(permissionName, "Allows players to use portal " + portalName);
                                Bukkit.getServer().getPluginManager().addPermission(portalPermission);
                                this.getConfig().set("portals." + portalName + ".pos1", (Object)this.locationToString(this.pos1.get(p.getUniqueId()), true));
                                this.getConfig().set("portals." + portalName + ".pos2", (Object)this.locationToString(this.pos2.get(p.getUniqueId()), true));
                                if (this.getConfig().get("portals." + portalName + ".commands") == null) {
                                    this.getConfig().set("portals." + portalName + ".commands", new ArrayList());
                                }
                                this.getConfig().set("portals." + portalName + ".permission", (Object)portalPermission.getName());
                                this.saveConfig();
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("positionsAdded")) + portalName)));
                            } else {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("invalidPositions")));
                            }
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("consoleCannotExecute")));
                        }
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("invalidPortalName")));
                    }
                } else if (args[0].equalsIgnoreCase("commands")) {
                    if (args.length > 1) {
                        String portalName = args[1];
                        if (this.getConfig().get("portals." + portalName) == null) {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("portalNotFound")));
                            return true;
                        }
                        if (this.getConfig().get("portals." + portalName + ".commands") == null) {
                            this.getConfig().set("portals." + portalName + ".commands", new ArrayList());
                            this.reloadConfig();
                        }
                        List commands = this.getConfig().getStringList("portals." + portalName + ".commands");
                        if (args.length > 2) {
                            if (args[2].equalsIgnoreCase("add")) {
                                if (args.length > 3) {
                                    String commandToAdd = "";
                                    int x = 0;
                                    String[] stringArray = args;
                                    int n = args.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String arg = stringArray[n2];
                                        if (x <= 2) {
                                            ++x;
                                        } else {
                                            commandToAdd = String.valueOf(commandToAdd) + " " + arg;
                                        }
                                        ++n2;
                                    }
                                    commands.add(commandToAdd);
                                    this.getConfig().set("portals." + portalName + ".commands", (Object)commands);
                                    this.saveConfig();
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("commandAddedToList")) + portalName)));
                                } else {
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("commandAdd")));
                                }
                            } else if (args[2].equalsIgnoreCase("list")) {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("commandList")) + portalName)));
                                int x = 0;
                                while (x < commands.size()) {
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6[" + x + "] " + (String)commands.get(x))));
                                    ++x;
                                }
                            } else if (args[2].equalsIgnoreCase("remove")) {
                                if (args.length > 3) {
                                    if (MyPortalsCommands.isDigit(args[3])) {
                                        int index = Integer.parseInt(args[3]);
                                        if (index >= 0 && index < commands.size()) {
                                            String removedCommand = (String)commands.remove(index);
                                            this.getConfig().set("portals." + portalName + ".commands", (Object)commands);
                                            this.saveConfig();
                                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("commandRemoved")) + removedCommand)));
                                        } else {
                                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("commandNotFound")));
                                        }
                                    } else {
                                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("invalidNumber")));
                                    }
                                } else {
                                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("insertPositionCommand")));
                                }
                            } else {
                                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("invalidAction")));
                            }
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("chooseAction")));
                        }
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("insertPortalName")));
                    }
                } else if (args[0].equalsIgnoreCase("deleteportal")) {
                    if (args.length > 1) {
                        String portalName = args[1];
                        if (this.getConfig().get("portals." + portalName) != null) {
                            this.getConfig().set("portals." + portalName, null);
                            this.saveConfig();
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("portalDeletedInfo")) + portalName)));
                        } else {
                            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("portalNotFound")));
                        }
                    } else {
                        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("insertPortalNameToRemove")));
                    }
                } else {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eMyPortalsCommands"));
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands reload"));
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands wand"));
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands portals"));
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands setportal <name>"));
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands commands <name> <add/list/remove> [command/position command]"));
                    sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7/myportalscommands deleteportal <name>"));
                }
            }
        } else {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("noPermission")));
        }
        return true;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player p = event.getPlayer();
        if (!this.playersPortalsIn.containsKey(p.getUniqueId())) {
            this.playersPortalsIn.put(p.getUniqueId(), new ArrayList());
        }
        for (String portalName : this.getConfig().getConfigurationSection("portals").getKeys(false)) {
            try {
                Location pos1 = this.stringToLocation(this.getConfig().getString("portals." + portalName + ".pos1"));
                Location pos2 = this.stringToLocation(this.getConfig().getString("portals." + portalName + ".pos2"));
                if (this.isInArea(p.getLocation(), pos1, pos2)) {
                    if (this.playersPortalsIn.get(p.getUniqueId()).contains(portalName)) continue;
                    this.playersPortalsIn.get(p.getUniqueId()).add(portalName);
                    if (p.hasPermission("myportalscommands.portal." + portalName)) {
                        for (String command : this.getConfig().getStringList("portals." + portalName + ".commands")) {
                            if (command.startsWith("console:")) {
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", p.getName()).replace("console:", ""));
                                continue;
                            }
                            Bukkit.dispatchCommand((CommandSender)p, (String)command.replace("%player%", p.getName()));
                        }
                        continue;
                    }
                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("noPermission")));
                    continue;
                }
                this.playersPortalsIn.get(p.getUniqueId()).remove(portalName);
            }
            catch (Exception ex) {
                this.getLogger().warning(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(this.messages.getString("portalError")) + portalName)));
                ex.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        ItemStack item = event.getItem();
        if (item != null && item.isSimilar(this.getWand()) && p.hasPermission("myportalscommands.admin")) {
            event.setCancelled(true);
            if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
                this.pos1.put(p.getUniqueId(), event.getClickedBlock().getLocation());
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("pos1Set")));
            } else if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                this.pos2.put(p.getUniqueId(), event.getClickedBlock().getLocation());
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("pos2Set")));
            }
        }
    }
}

