/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ConfigLocationUtil;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.egginformation.EggInformationMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.ListPaginatedMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EggListMenu
extends ListPaginatedMenu {
    public EggListMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return "Eggs list";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().eggs.contains("Eggs.")) {
            keys.addAll(Main.getInstance().eggs.getConfigurationSection("Eggs.").getKeys(false));
            for (String id : Main.getInstance().eggs.getConfigurationSection("Eggs.").getKeys(false)) {
                if (!Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getLocalizedName().equals(id)) continue;
                if (e.getAction() == InventoryAction.PICKUP_ALL) {
                    ConfigLocationUtil location = new ConfigLocationUtil(Main.getInstance(), "Eggs." + id);
                    if (location.loadBlockLocation() != null) {
                        p.teleport(location.loadLocation().add(0.5, 0.0, 0.5));
                    }
                    p.closeInventory();
                    p.sendMessage(Main.getInstance().getMessage("TeleportedToEggMessage").replaceAll("%ID%", id));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                    continue;
                }
                if (e.getAction() != InventoryAction.PICKUP_HALF) continue;
                new EggInformationMenu(Main.getPlayerMenuUtility(p)).open(id);
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
            }
        }
        if (e.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
            p.closeInventory();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.EMERALD_BLOCK)) {
            if (Main.getInstance().getRefreshCooldown().containsKey(p.getName()) && Main.getInstance().getRefreshCooldown().get(p.getName()) > System.currentTimeMillis()) {
                p.sendMessage(Main.getInstance().getMessage("RefreshWaitMessage"));
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                return;
            }
            Main.getInstance().getRefreshCooldown().put(p.getName(), System.currentTimeMillis() + 3000L);
            new EggListMenu(Main.getPlayerMenuUtility(p)).open();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.PLAYER_HEAD)) {
            if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Left")) {
                if (this.page == 0) {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnFirstPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    --this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Right")) {
                if (this.index + 1 < keys.size()) {
                    ++this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnLastPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.addMenuBorder();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().eggs.contains("Eggs.")) {
            keys.addAll(Main.getInstance().eggs.getConfigurationSection("Eggs.").getKeys(false));
        } else {
            this.inventory.setItem(22, new ItemBuilder(Material.RED_STAINED_GLASS).setDisplayname("\u00a74\u00a7lNo Eggs Placed").setLore("\u00a77You can add eggs by using", "\u00a7e/egghunt placeEggs\u00a77.").build());
        }
        if (keys != null && !keys.isEmpty()) {
            for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index >= keys.size()) break;
                if (keys.get(this.index) == null) continue;
                String x = Main.getInstance().eggs.getString("Eggs." + (String)keys.get(this.index) + ".X");
                String y = Main.getInstance().eggs.getString("Eggs." + (String)keys.get(this.index) + ".Y");
                String z = Main.getInstance().eggs.getString("Eggs." + (String)keys.get(this.index) + ".Z");
                int random = new Random().nextInt(7);
                String date = VersionManager.getEggManager().getEggDatePlaced((String)keys.get(this.index));
                String time = VersionManager.getEggManager().getEggTimePlaced((String)keys.get(this.index));
                String timesFound = String.valueOf(VersionManager.getEggManager().getTimesFound((String)keys.get(this.index)));
                this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setSkullOwner(VersionManager.getEggManager().getRandomEggTexture(random)).setDisplayname("\u00a72\u00a7lEgg \u00a77(ID#" + (String)keys.get(this.index) + ")").setLore("\u00a79Location:", "\u00a77X: \u00a7e" + x, "\u00a77Y: \u00a7e" + y, "\u00a77Z: \u00a7e" + z, "", "\u00a79Information:", "\u00a77Times found: \u00a76" + timesFound, "", "\u00a79Placed:", "\u00a77Date: \u00a76" + date, "\u00a77Time: \u00a76" + time, "", "\u00a7eLEFT-CLICK to teleport.", "\u00a7eRIGHT-CLICK for information.").setLocalizedName((String)keys.get(this.index)).build()});
            }
        }
    }
}

