/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.inventorymanager.leaderboardmenu;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.util.enums.LeaderboardSortTypes;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.leaderboardmenu.LeaderboardPaginatedMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EggLeaderboardMenu
extends LeaderboardPaginatedMenu {
    public EggLeaderboardMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return "Eggs leaderboard";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().eggs.contains("FoundEggs.")) {
            keys.addAll(Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false));
        }
        if (e.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
            p.closeInventory();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.EMERALD_BLOCK)) {
            if (Main.getInstance().getRefreshCooldown().containsKey(p.getName()) && Main.getInstance().getRefreshCooldown().get(p.getName()) > System.currentTimeMillis()) {
                p.sendMessage(Main.getInstance().getMessage("RefreshWaitMessage"));
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                return;
            }
            Main.getInstance().getRefreshCooldown().put(p.getName(), System.currentTimeMillis() + 3000L);
            new EggLeaderboardMenu(Main.getPlayerMenuUtility(p)).open();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.PLAYER_HEAD)) {
            if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Left")) {
                if (this.page == 0) {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnFirstPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    --this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Right")) {
                if (this.index + 1 < keys.size()) {
                    ++this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnLastPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            }
        } else if (e.getCurrentItem().getType().equals((Object)Material.HOPPER) && ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Sort")) {
            LeaderboardSortTypes sortTypes = Main.getInstance().getSortTypeLeaderboard().get(this.playerMenuUtility.getOwner());
            Main.getInstance().getSortTypeLeaderboard().remove(this.playerMenuUtility.getOwner());
            switch (sortTypes) {
                case ALL: {
                    Main.getInstance().getSortTypeLeaderboard().put(this.playerMenuUtility.getOwner(), LeaderboardSortTypes.TOP10);
                    break;
                }
                case TOP10: {
                    Main.getInstance().getSortTypeLeaderboard().put(this.playerMenuUtility.getOwner(), LeaderboardSortTypes.TOP3);
                    break;
                }
                case TOP3: {
                    Main.getInstance().getSortTypeLeaderboard().put(this.playerMenuUtility.getOwner(), LeaderboardSortTypes.YOU);
                    break;
                }
                case YOU: {
                    Main.getInstance().getSortTypeLeaderboard().put(this.playerMenuUtility.getOwner(), LeaderboardSortTypes.ALL);
                }
            }
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
            super.open();
        }
    }

    @Override
    public void setMenuItems() {
        this.addMenuBorder();
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (Main.getInstance().eggs.contains("FoundEggs.")) {
            for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
                leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
            }
            for (int i = 0; i < leaderboard.size(); ++i) {
                keys.add(String.valueOf(i));
            }
        } else {
            this.inventory.setItem(22, new ItemBuilder(Material.RED_STAINED_GLASS).setDisplayname("\u00a74\u00a7lNo Player").setLore("\u00a77There are no players in the leaderboard.").build());
        }
        if (keys != null && !keys.isEmpty()) {
            ArrayList leaderList = new ArrayList(leaderboard.entrySet());
            block8: for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index >= keys.size()) break;
                if (keys.get(this.index) == null) continue;
                LeaderboardSortTypes sortTypes = Main.getInstance().getSortTypeLeaderboard().get(this.playerMenuUtility.getOwner());
                leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
                String playerName = (String)((Map.Entry)leaderList.get(i)).getKey();
                int count = (Integer)((Map.Entry)leaderList.get(i)).getValue();
                int maxEggs = VersionManager.getEggManager().getMaxEggs();
                switch (sortTypes) {
                    case ALL: {
                        this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setOwner(playerName).setDisplayname("\u00a76\u00a7l" + (i + 1) + "\u00a76th \u00a72\u00a7n" + playerName + (playerName.equals(this.playerMenuUtility.getOwner().getName()) ? "\u00a7r \u00a7a\u00a7lYOU" : "")).setLore(new String[]{"", "\u00a77Eggs Found: \u00a73" + count, "\u00a77Eggs Remaining: \u00a73" + (maxEggs - count), "\u00a77Max Eggs: \u00a73" + maxEggs, "", 9 >= i ? "\u00a7eTHIS PLAYER IS IN THE TOP 10!" : "\u00a7c" + (i - 9) + " place behind 10th place"}).build()});
                        continue block8;
                    }
                    case TOP3: {
                        if (i >= 3) continue block8;
                        this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setOwner(playerName).setDisplayname("\u00a76\u00a7l" + (i + 1) + "\u00a76th \u00a72\u00a7n" + playerName + (playerName.equals(this.playerMenuUtility.getOwner().getName()) ? "\u00a7r \u00a7a\u00a7lYOU" : "")).setLore("", "\u00a77Eggs Found: \u00a73" + count, "\u00a77Eggs Remaining: \u00a73" + (maxEggs - count), "\u00a77Max Eggs: \u00a73" + maxEggs, "", "\u00a7eTHIS PLAYER IS IN THE TOP 10!").build()});
                        continue block8;
                    }
                    case TOP10: {
                        if (i >= 10) continue block8;
                        this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setOwner(playerName).setDisplayname("\u00a76\u00a7l" + (i + 1) + "\u00a76th \u00a72\u00a7n" + playerName + (playerName.equals(this.playerMenuUtility.getOwner().getName()) ? "\u00a7r \u00a7a\u00a7lYOU" : "")).setLore("", "\u00a77Eggs Found: \u00a73" + count, "\u00a77Eggs Remaining: \u00a73" + (maxEggs - count), "\u00a77Max Eggs: \u00a73" + maxEggs, "", "\u00a7eTHIS PLAYER IS IN THE TOP 10!").build()});
                        continue block8;
                    }
                    case YOU: {
                        if (!playerName.equals(this.playerMenuUtility.getOwner().getName())) continue block8;
                        this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setOwner(playerName).setDisplayname("\u00a76\u00a7l" + (i + 1) + "\u00a76th \u00a72\u00a7n" + playerName + (playerName.equals(this.playerMenuUtility.getOwner().getName()) ? "\u00a7r \u00a7a\u00a7lYOU" : "")).setLore(new String[]{"", "\u00a77Eggs Found: \u00a73" + count, "\u00a77Eggs Remaining: \u00a73" + (maxEggs - count), "\u00a77Max Eggs: \u00a73" + maxEggs, "", 9 >= i ? "\u00a7eTHIS PLAYER IS IN THE TOP 10!" : "\u00a7c" + (i - 9) + " place behind 10th place"}).build()});
                    }
                }
            }
        }
    }
}

