/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.inventorymanager.hintInventory;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HintInventoryCreator
implements Listener {
    private Player player;
    private Inventory inventory;
    private boolean active;
    private int currentSlot;

    public HintInventoryCreator(Player player, Inventory inventory, boolean active) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
        this.player = player;
        this.inventory = inventory;
        this.active = active;
        this.open(player);
    }

    private void open(Player player) {
        if (player != null) {
            player.openInventory(this.inventory);
            this.startAnimating();
        }
    }

    private void startAnimating() {
        new BukkitRunnable(){

            public void run() {
                if (HintInventoryCreator.this.active) {
                    HintInventoryCreator.this.inventory.clear();
                    HintInventoryCreator.this.currentSlot = HintInventoryCreator.this.getRandomSlot();
                    HintInventoryCreator.this.inventory.setItem(HintInventoryCreator.this.currentSlot, new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setDisplayname("\u00a7aEnter").build());
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 60L, 20L);
    }

    private int getRandomSlot() {
        return new Random().nextInt(this.inventory.getSize());
    }

    @EventHandler
    public void onClickInventory(InventoryClickEvent event) {
        if (event.getCurrentItem() != null && event.getCurrentItem().getItemMeta() != null && event.getInventory().equals(this.inventory)) {
            event.setCancelled(true);
            if (Objects.requireNonNull(event.getClickedInventory()).getItem(this.currentSlot) != null) {
                this.player.sendMessage("\u00a7aEnter ture");
            }
        }
    }
}

