/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.inventorymanager.eggplacelist;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.eggplacelist.PlacePaginatedMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EggPlaceMenu
extends PlacePaginatedMenu {
    public EggPlaceMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return "Eggs place list";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().getConfig().contains("PlaceEggs.")) {
            keys.addAll(Main.getInstance().getConfig().getConfigurationSection("PlaceEggs.").getKeys(false));
            for (String id : Main.getInstance().getConfig().getConfigurationSection("PlaceEggs.").getKeys(false)) {
                if (!Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getLocalizedName().equals(id)) continue;
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                p.getInventory().addItem(new ItemStack[]{new ItemBuilder(e.getCurrentItem().getType()).setSkullOwner(Main.getTexture(Main.getInstance().getConfig().getString("PlaceEggs." + id + ".texture"))).setDisplayname("\u00a76Easter Egg").setLore("\u00a77Place this egg around the map", "\u00a77that everyone can search and find it.").build()});
            }
        }
        if (e.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
            p.closeInventory();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.EMERALD_BLOCK)) {
            if (Main.getInstance().getRefreshCooldown().containsKey(p.getName()) && Main.getInstance().getRefreshCooldown().get(p.getName()) > System.currentTimeMillis()) {
                p.sendMessage(Main.getInstance().getMessage("RefreshWaitMessage"));
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                return;
            }
            Main.getInstance().getRefreshCooldown().put(p.getName(), System.currentTimeMillis() + 3000L);
            new EggPlaceMenu(Main.getPlayerMenuUtility(p)).open();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.PLAYER_HEAD)) {
            if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Left")) {
                if (this.page == 0) {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnFirstPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    --this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Right")) {
                if (this.index + 1 < keys.size()) {
                    ++this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnLastPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Information")) {
                TextComponent c = new TextComponent("\u00a77Join the discord to get all information how to add custom egg textures. \n");
                TextComponent clickme = new TextComponent("\u00a76\u00a7l[CLICK HERE]");
                clickme.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a77Click to join.")));
                clickme.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/hNj9erE5EA"));
                c.addExtra((BaseComponent)clickme);
                p.spigot().sendMessage((BaseComponent)c);
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.addMenuBorder();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().getConfig().contains("PlaceEggs.")) {
            keys.addAll(Main.getInstance().getConfig().getConfigurationSection("PlaceEggs.").getKeys(false));
        } else {
            this.inventory.setItem(22, new ItemBuilder(Material.RED_STAINED_GLASS).setDisplayname("\u00a74\u00a7lNo Eggs").setLore("\u00a77You can add commands by using", "\u00a7e/egghunt placeEggs\u00a77.").build());
        }
        if (keys != null && !keys.isEmpty()) {
            for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index >= keys.size()) break;
                if (keys.get(this.index) == null) continue;
                this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setSkullOwner(Main.getTexture(Main.getInstance().getConfig().getString("PlaceEggs." + (String)keys.get(this.index) + ".texture"))).setDisplayname("\u00a7b\u00a7lEggs Type #" + (String)keys.get(this.index)).setLore("\u00a7eClick to get.").setLocalizedName((String)keys.get(this.index)).build()});
            }
        }
    }
}

