/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.inventorymanager.egginformation;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.egginformation.InformationPaginatedMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.EggListMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.Collections;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EggInformationMenu
extends InformationPaginatedMenu {
    public EggInformationMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return "Egg information";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        String id = this.inventory.getItem(0).getItemMeta().getLocalizedName();
        ArrayList keys = new ArrayList();
        for (String uuids : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            if (!Main.getInstance().eggs.contains("FoundEggs." + uuids + "." + id)) continue;
            Collections.addAll(keys, Main.getInstance().eggs.getString("FoundEggs." + uuids + ".Name"));
        }
        if (e.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
            p.closeInventory();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.EMERALD_BLOCK)) {
            if (Main.getInstance().getRefreshCooldown().containsKey(p.getName()) && Main.getInstance().getRefreshCooldown().get(p.getName()) > System.currentTimeMillis()) {
                p.sendMessage(Main.getInstance().getMessage("RefreshWaitMessage"));
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                return;
            }
            Main.getInstance().getRefreshCooldown().put(p.getName(), System.currentTimeMillis() + 3000L);
            new EggInformationMenu(Main.getPlayerMenuUtility(p)).open(this.inventory.getItem(0).getItemMeta().getLocalizedName());
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.PLAYER_HEAD)) {
            if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Left")) {
                if (this.page == 0) {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnFirstPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    --this.page;
                    super.open(id);
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Right")) {
                if (this.index + 1 < keys.size()) {
                    ++this.page;
                    super.open(id);
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnLastPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Back")) {
                new EggListMenu(Main.getPlayerMenuUtility(p)).open();
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
            }
        }
    }

    @Override
    public void setMenuItems(String eggId) {
        this.inventory.setItem(0, new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setDisplayname("\u00a7c").setLocalizedName(eggId).build());
        this.addMenuBorder();
        ArrayList keys = new ArrayList();
        ArrayList uuid = new ArrayList();
        for (String uuids : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            if (!Main.getInstance().eggs.contains("FoundEggs." + uuids + "." + eggId)) continue;
            Collections.addAll(keys, Main.getInstance().eggs.getString("FoundEggs." + uuids + ".Name"));
            Collections.addAll(uuid, uuids);
        }
        if (keys != null && !keys.isEmpty()) {
            for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index < keys.size()) {
                    if (keys.get(this.index) == null) continue;
                    String maxEggs = String.valueOf(VersionManager.getEggManager().getMaxEggs());
                    String date = VersionManager.getEggManager().getEggDateCollected((String)uuid.get(this.index), eggId);
                    String time = VersionManager.getEggManager().getEggTimeCollected((String)uuid.get(this.index), eggId);
                    String eggsFound = Main.getInstance().eggs.getString("FoundEggs." + (String)uuid.get(this.index) + ".Count");
                    this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.PLAYER_HEAD).setOwner((String)keys.get(this.index)).setDisplayname("\u00a76\u00a7l" + (String)keys.get(this.index) + " \u00a77(" + (String)uuid.get(this.index) + ")").setLore("\u00a77" + (String)keys.get(this.index) + " have found the \u00a72egg #" + eggId + "\u00a77.", "", "\u00a79Information of " + (String)keys.get(this.index) + ":", "\u00a77Eggs found: \u00a76" + eggsFound + "/" + maxEggs, "", "\u00a79Collected:", "\u00a77Date: \u00a76" + date, "\u00a77Time: \u00a76" + time).setLocalizedName((String)keys.get(this.index)).build()});
                    continue;
                }
                break;
            }
        } else {
            this.inventory.setItem(22, new ItemBuilder(Material.RED_STAINED_GLASS).setDisplayname("\u00a74\u00a7lNo Founds").setLore("\u00a77No player has found this egg yet.").build());
        }
    }
}

