/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.inventorymanager.eggfoundrewardmenu;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.eggfoundrewardmenu.RewardPaginatedMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.PlayerMenuUtility;
import java.util.ArrayList;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EggRewardMenu
extends RewardPaginatedMenu {
    public EggRewardMenu(PlayerMenuUtility playerMenuUtility) {
        super(playerMenuUtility);
    }

    @Override
    public String getMenuName() {
        return "Eggs found rewards";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().getConfig().contains("Rewards.")) {
            keys.addAll(Main.getInstance().getConfig().getConfigurationSection("Rewards.").getKeys(false));
            for (String id : Main.getInstance().getConfig().getConfigurationSection("Rewards.").getKeys(false)) {
                if (!Objects.requireNonNull(e.getCurrentItem().getItemMeta()).getLocalizedName().equals(id)) continue;
                VersionManager.getInventoryManager().createCommandSettingsMenu(p, id);
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
            }
        }
        if (e.getCurrentItem().getType().equals((Object)Material.BARRIER)) {
            p.closeInventory();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.EMERALD_BLOCK)) {
            if (Main.getInstance().getRefreshCooldown().containsKey(p.getName()) && Main.getInstance().getRefreshCooldown().get(p.getName()) > System.currentTimeMillis()) {
                p.sendMessage(Main.getInstance().getMessage("RefreshWaitMessage"));
                p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                return;
            }
            Main.getInstance().getRefreshCooldown().put(p.getName(), System.currentTimeMillis() + 3000L);
            new EggRewardMenu(Main.getPlayerMenuUtility(p)).open();
            p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
        } else if (e.getCurrentItem().getType().equals((Object)Material.PLAYER_HEAD)) {
            if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Left")) {
                if (this.page == 0) {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnFirstPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    --this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Right")) {
                if (this.index + 1 < keys.size()) {
                    ++this.page;
                    super.open();
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventorySuccessSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    p.sendMessage(Main.getInstance().getMessage("AlreadyOnLastPageMessage"));
                    p.playSound(p.getLocation(), VersionManager.getSoundManager().playInventoryFailedSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                }
            } else if (ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName()).equalsIgnoreCase("Add command")) {
                if (Main.getInstance().getPlayerAddCommand().containsKey(p)) {
                    p.sendMessage(Main.getInstance().getMessage("OnlyOneCommandMessage"));
                    return;
                }
                p.closeInventory();
                Main.getInstance().getPlayerAddCommand().put(p, 120);
                TextComponent c = new TextComponent("\n\n\n\n\n" + Main.getInstance().getMessage("EnterNewCommandMessage") + "\n\n");
                TextComponent clickme = new TextComponent("\u00a79-----------\u00a73\u00a7l[PLACEHOLDERS] \u00a77(Hover)\u00a79-----------");
                clickme.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)"\u00a72Available placeholders:\n\u00a7b- %PLAYER% --> Name of the player\n\u00a7b- & --> For color codes (&6=gold)\n\u00a7b- %EGGS_FOUND% --> How many eggs the player has found\n\u00a7b- %EGGS_MAX% --> How many eggs are placed\n\u00a7b- %PREFIX% --> The prefix of the plugin")));
                c.addExtra((BaseComponent)clickme);
                p.spigot().sendMessage((BaseComponent)c);
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.addMenuBorder();
        ArrayList keys = new ArrayList();
        if (Main.getInstance().getConfig().contains("Rewards.")) {
            keys.addAll(Main.getInstance().getConfig().getConfigurationSection("Rewards.").getKeys(false));
        } else {
            this.inventory.setItem(22, new ItemBuilder(Material.RED_STAINED_GLASS).setDisplayname("\u00a74\u00a7lNo Commands").setLore("\u00a77You can add commands by using", "\u00a7e/egghunt placeEggs\u00a77.").build());
        }
        if (keys != null && !keys.isEmpty()) {
            for (int i = 0; i < this.getMaxItemsPerPage(); ++i) {
                this.index = this.getMaxItemsPerPage() * this.page + i;
                if (this.index < keys.size()) {
                    if (keys.get(this.index) == null) continue;
                    String command = Main.getInstance().getConfig().getString("Rewards." + (String)keys.get(this.index) + ".command").replaceAll("\u00a7", "&");
                    boolean enabled = Main.getInstance().getConfig().getBoolean("Rewards." + (String)keys.get(this.index) + ".enabled");
                    int type = Main.getInstance().getConfig().getInt("Rewards." + (String)keys.get(this.index) + ".type");
                    this.inventory.addItem(new ItemStack[]{new ItemBuilder(Main.getInstance().getMaterial(Main.getInstance().getConfig().getString("Settings.RewardInventoryMaterial"))).setDisplayname("\u00a7b\u00a7lCommand \u00a77#" + (String)keys.get(this.index)).setLore("", "\u00a79Information:", "\u00a77Command: \u00a76" + command, "\u00a77Command Enabled: " + (enabled ? "\u00a7atrue" : "\u00a7cfalse"), "\u00a77Type: \u00a76" + type, "", "\u00a7a\u00a7lNote:", "\u00a72Type 0:", "\u00a77Type 0 means that this command will be", "\u00a77be executed if the player found \u00a77\u00a7lone \u00a77egg.", "\u00a72Type 1:", "\u00a77Type 1 means that this command will be", "\u00a77be executed if the player had found \u00a77\u00a7lall \u00a77egg.", "", "\u00a7eClick to configure the command.").setLocalizedName((String)keys.get(this.index)).build()});
                    continue;
                }
                break;
            }
        } else {
            this.inventory.setItem(22, new ItemBuilder(Material.RED_STAINED_GLASS).setDisplayname("\u00a74\u00a7lNo Commands").setLore("\u00a77You can add commands by using", "\u00a7e/egghunt placeEggs\u00a77.").build());
        }
    }
}

