/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.versions.managers.eggmanager;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ConfigLocationUtil;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.util.saveinventory.Config;
import de.theredend2000.advancedegghunt.util.saveinventory.Serialization;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.eggmanager.EggManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EggManager_1_19_R2
implements EggManager {
    @Override
    public String getRandomEggTexture(int id) {
        String texture = "";
        switch (id) {
            case 0: {
                texture = Main.getTexture("ZWNlZGRjMjNmOWQ5NmJhYWEwZDJkN2I5ZWMxODBjZDdiZWE1NDQ3ZDM5YzQyNWNhOWU0NGQ4ODA4ZWExMWVhMCJ9fX0=");
                break;
            }
            case 1: {
                texture = Main.getTexture("ODYyMWE1MjY5ODY5ODQ3NTMxMDE1NjYzMDBhMzU2YjVmMzBkNjk3NWExZWZlNjI5YWJmMjY5NDc2NWQ5NmNjIn19fQ==");
                break;
            }
            case 2: {
                texture = Main.getTexture("NmUzMmE3ZGU3YTY3MmNjNjhmYTdhMjcyYmFhNmE4OWViZDQ0MGMzMmRjZjQ0ZTc3MDU3MDY4OTg5MDQyZjdjNiJ9fX0=");
                break;
            }
            case 3: {
                texture = Main.getTexture("NmI3NDQ2NTUwZjBmOTU3NmI3MzE3MjhiNWNiZWIyYmNlYTI1ZmQxYTU1NjBhMTdiMjM1N2U2MTZmYmM2NTYyMSJ9fX0=");
                break;
            }
            case 4: {
                texture = Main.getTexture("ZmU2ZmFiMDkxZTQ5NmMwOTY5MTA0ODBkYTBkODVlZTkxOWJjNDlhYTMxNzc1Y2FkYmJmNTA1ZWY0MTFiNWY5NCJ9fX0=");
                break;
            }
            case 5: {
                texture = Main.getTexture("ODUzMWNjMjY5YzhlNDcwNmU4OTJmOGEwZmIzNTFiMTA5MDE1NmIzZjYyNjFkODE2MzVkMDdhY2FkYmU2Y2UwZSJ9fX0=");
                break;
            }
            case 6: {
                texture = Main.getTexture("YTZhNjA1MWY3ZjZmNDM5ZDhmMjE0YzIzNGU4ZTJjNDc3NjMwMDUyNDMyZTQyNjA3ZjA0MDRiODQwYjUzY2VhYiJ9fX0=");
                break;
            }
            case 7: {
                texture = Main.getTexture("MjEzYjJlMjhlMDM3MTAwNzM5MTMwYjJlYjkwZWY0OTFjNmMzZGZmNWRlNTYxNWQyZjZkZmQxZTQ2YzljMmY3YyJ9fX0=");
            }
        }
        return texture;
    }

    @Override
    public ItemStack giveFinishedEggToPlayer(int id) {
        return new ItemBuilder(Material.PLAYER_HEAD).setDisplayname("\u00a76Easter Egg").setLore("\u00a77Place this egg around the map", "\u00a77that everyone can search and find it.").setSkullOwner(this.getRandomEggTexture(id)).build();
    }

    @Override
    public void finishEggPlacing(Player player) {
        Config cfg = new Config(Main.getInstance(), player.getName());
        String[] values = new String[]{cfg.getConfig().getString("inv"), cfg.getConfig().getString("armor")};
        ItemStack[][] items = Serialization.base64toInv(values);
        player.getInventory().clear();
        player.getInventory().setContents(items[0]);
        player.getInventory().setArmorContents(items[1]);
    }

    @Override
    public void startEggPlacing(Player player) {
        Config cfg = new Config(Main.getInstance(), player.getName());
        String[] values = Serialization.invToBase64(player.getInventory());
        cfg.getConfig().set("inv", (Object)values[0]);
        cfg.getConfig().set("armor", (Object)values[1]);
        cfg.saveInv();
        player.getInventory().clear();
    }

    @Override
    public void saveEgg(Player player, Location location) {
        if (Main.getInstance().eggs.contains("Eggs.")) {
            ConfigurationSection chestsSection = Main.getInstance().eggs.getConfigurationSection("Eggs.");
            int nextNumber = 0;
            Set keys = chestsSection.getKeys(false);
            if (!keys.isEmpty()) {
                for (int i = 0; i <= keys.size(); ++i) {
                    String key = Integer.toString(i);
                    if (keys.contains(key)) continue;
                    nextNumber = i;
                    break;
                }
            }
            new ConfigLocationUtil(Main.getInstance(), location, "Eggs." + nextNumber).saveBlockLocation();
            player.sendMessage(Main.getInstance().getMessage("EggPlacedMessage").replaceAll("%ID%", String.valueOf(nextNumber)));
        } else {
            new ConfigLocationUtil(Main.getInstance(), location, "Eggs.0").saveBlockLocation();
            player.sendMessage(Main.getInstance().getMessage("EggPlacedMessage").replaceAll("%ID%", "0"));
        }
        this.updateMaxEggs();
    }

    @Override
    public void removeEgg(Player player, Block block) {
        Main plugin = Main.getInstance();
        if (plugin.eggs.contains("Eggs.")) {
            HashSet<String> keys = new HashSet<String>();
            keys.clear();
            for (String key : plugin.eggs.getConfigurationSection("Eggs.").getKeys(false)) {
                keys.add(key);
                ConfigLocationUtil location = new ConfigLocationUtil(plugin, "Eggs." + key + ".");
                if (location.loadBlockLocation() == null || block.getX() != location.loadLocation().getBlockX() || block.getY() != location.loadLocation().getBlockY() || block.getZ() != location.loadLocation().getBlockZ()) continue;
                plugin.eggs.set("Eggs." + key, null);
                plugin.saveEggs();
                player.sendMessage(plugin.getMessage("EggBreakMessage").replaceAll("%ID%", key));
                keys.remove(key);
            }
            if (plugin.eggs.contains("FoundEggs.")) {
                for (String uuids : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
                    for (String keys2 : Main.getInstance().eggs.getConfigurationSection("FoundEggs." + uuids).getKeys(false)) {
                        ConfigLocationUtil location = new ConfigLocationUtil(plugin, "FoundEggs." + uuids + "." + keys2 + ".");
                        if (location.loadBlockLocation() == null || block.getX() != location.loadLocation().getBlockX() || block.getY() != location.loadLocation().getBlockY() || block.getZ() != location.loadLocation().getBlockZ()) continue;
                        plugin.eggs.set("FoundEggs." + uuids + "." + keys2, null);
                        plugin.eggs.set("FoundEggs." + uuids + ".Count", (Object)(plugin.eggs.getInt("FoundEggs." + uuids + ".Count") - 1));
                        plugin.saveEggs();
                    }
                }
            }
            if (keys.isEmpty()) {
                plugin.eggs.set("Eggs", null);
                plugin.saveEggs();
            }
            this.updateMaxEggs();
        }
    }

    @Override
    public boolean containsEgg(Block block) {
        Main plugin = Main.getInstance();
        if (!Main.getInstance().eggs.contains("Eggs.")) {
            return false;
        }
        for (String key : plugin.eggs.getConfigurationSection("Eggs.").getKeys(false)) {
            ConfigLocationUtil location = new ConfigLocationUtil(plugin, "Eggs." + key + ".");
            if (location.loadBlockLocation() == null || block.getX() != location.loadLocation().getBlockX() || block.getY() != location.loadLocation().getBlockY() || block.getZ() != location.loadLocation().getBlockZ()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEggID(Block block) {
        Main plugin = Main.getInstance();
        if (!Main.getInstance().eggs.contains("Eggs.")) {
            return null;
        }
        for (String key : plugin.eggs.getConfigurationSection("Eggs.").getKeys(false)) {
            ConfigLocationUtil location = new ConfigLocationUtil(plugin, "Eggs." + key + ".");
            if (location.loadBlockLocation() == null || block.getX() != location.loadLocation().getBlockX() || block.getY() != location.loadLocation().getBlockY() || block.getZ() != location.loadLocation().getBlockZ()) continue;
            return key;
        }
        return null;
    }

    @Override
    public void saveFoundEggs(Player player, Block block, String id) {
        Main.getInstance().eggs.set("Eggs." + id + ".TimesFound", (Object)(Main.getInstance().eggs.contains("Eggs." + id + ".TimesFound") ? Main.getInstance().eggs.getInt("Eggs." + id + ".TimesFound") + 1 : 1));
        Main.getInstance().saveConfig();
        new ConfigLocationUtil(Main.getInstance(), block.getLocation(), "FoundEggs." + player.getUniqueId() + "." + id).saveBlockLocation();
        Main.getInstance().eggs.set("FoundEggs." + player.getUniqueId() + ".Count", (Object)(Main.getInstance().eggs.contains("FoundEggs." + player.getUniqueId() + ".Count") ? Main.getInstance().eggs.getInt("FoundEggs." + player.getUniqueId() + ".Count") + 1 : 1));
        Main.getInstance().saveEggs();
        Main.getInstance().eggs.set("FoundEggs." + player.getUniqueId() + ".Name", (Object)player.getName());
        Main.getInstance().saveEggs();
        if (!Main.getInstance().getConfig().getBoolean("Settings.PlayerFoundOneEggRewards") || !Main.getInstance().getConfig().getBoolean("Settings.PlayerFoundAllEggsReward")) {
            player.sendMessage(Main.getInstance().getMessage("EggFoundMessage").replaceAll("%EGGS_FOUND%", String.valueOf(this.getEggsFound(player))).replaceAll("%EGGS_MAX%", String.valueOf(this.getMaxEggs())));
        }
    }

    @Override
    public int getTimesFound(String id) {
        return Main.getInstance().eggs.contains("Eggs." + id + ".TimesFound") ? Main.getInstance().eggs.getInt("Eggs." + id + ".TimesFound") : 0;
    }

    @Override
    public String getEggDatePlaced(String id) {
        return Main.getInstance().eggs.getString("Eggs." + id + ".Date");
    }

    @Override
    public String getEggTimePlaced(String id) {
        return Main.getInstance().eggs.getString("Eggs." + id + ".Time");
    }

    @Override
    public String getEggDateCollected(String uuid, String id) {
        return Main.getInstance().eggs.getString("FoundEggs." + uuid + "." + id + ".Date");
    }

    @Override
    public String getEggTimeCollected(String uuid, String id) {
        return Main.getInstance().eggs.getString("FoundEggs." + uuid + "." + id + ".Time");
    }

    @Override
    public boolean hasFound(Player player, String id) {
        return Main.getInstance().eggs.contains("FoundEggs." + player.getUniqueId() + "." + id);
    }

    @Override
    public int getMaxEggs() {
        return Main.getInstance().eggs.getInt("MaxEggs");
    }

    @Override
    public int getEggsFound(Player player) {
        return Main.getInstance().eggs.getInt("FoundEggs." + player.getUniqueId() + ".Count");
    }

    @Override
    public void updateMaxEggs() {
        ArrayList<String> maxEggs = new ArrayList<String>();
        maxEggs.clear();
        if (!Main.getInstance().eggs.contains("Eggs.")) {
            return;
        }
        for (String id : Main.getInstance().eggs.getConfigurationSection("Eggs.").getKeys(false)) {
            maxEggs.add(id);
        }
        Main.getInstance().eggs.set("MaxEggs", (Object)maxEggs.size());
        Main.getInstance().saveEggs();
    }

    @Override
    public boolean checkFoundAll(Player player) {
        return this.getEggsFound(player) == this.getMaxEggs();
    }

    @Override
    public void spawnEggParticle() {
        new BukkitRunnable(){

            public void run() {
                if (!Main.getInstance().eggs.contains("Eggs.")) {
                    return;
                }
                for (String key : Main.getInstance().eggs.getConfigurationSection("Eggs.").getKeys(false)) {
                    ConfigLocationUtil locationUtil = new ConfigLocationUtil(Main.getInstance(), "Eggs." + key);
                    if (locationUtil.loadBlockLocation() == null) continue;
                    String world = Main.getInstance().eggs.getString("Eggs." + key + ".World");
                    int x = Main.getInstance().eggs.getInt("Eggs." + key + ".X");
                    int y = Main.getInstance().eggs.getInt("Eggs." + key + ".Y");
                    int z = Main.getInstance().eggs.getInt("Eggs." + key + ".Z");
                    Location loc = new Location(Bukkit.getWorld((String)world), (double)x, (double)y, (double)z).add(0.5, 0.5, 0.5);
                    for (Entity e : loc.getWorld().getNearbyEntities(loc, 10.0, 10.0, 10.0)) {
                        if (!(e instanceof Player)) continue;
                        Player p = (Player)e;
                        if (VersionManager.getEggManager().hasFound(p, key)) {
                            p.spawnParticle(Particle.VILLAGER_HAPPY, loc, 1, 0.2, 0.1, 0.2, 0.0);
                            continue;
                        }
                        p.spawnParticle(Particle.CRIT, loc, 1, 0.2, 0.1, 0.2, 0.0);
                    }
                    int radius = Main.getInstance().getConfig().getInt("Settings.ShowEggsNearbyMessageRadius");
                    for (Entity e : loc.getWorld().getNearbyEntities(loc, (double)radius, (double)radius, (double)radius)) {
                        if (!(e instanceof Player)) continue;
                        Player p = (Player)e;
                        if (VersionManager.getEggManager().hasFound(p, key)) continue;
                        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(Main.getInstance().getMessage("EggNearbyMessage")));
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 5L);
    }

    @Override
    public void showAllEggs() {
        if (!Main.getInstance().eggs.contains("Eggs.")) {
            return;
        }
        for (String key : Main.getInstance().eggs.getConfigurationSection("Eggs.").getKeys(false)) {
            ConfigLocationUtil locationUtil = new ConfigLocationUtil(Main.getInstance(), "Eggs." + key);
            if (locationUtil.loadBlockLocation() == null) continue;
            String world = Main.getInstance().eggs.getString("Eggs." + key + ".World");
            int x = Main.getInstance().eggs.getInt("Eggs." + key + ".X");
            int y = Main.getInstance().eggs.getInt("Eggs." + key + ".Y");
            int z = Main.getInstance().eggs.getInt("Eggs." + key + ".Z");
            Location loc = new Location(Bukkit.getWorld((String)world), (double)x, (double)y, (double)z).add(0.5, 0.5, 0.5);
            ArmorStand armorStand = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class);
            armorStand.setGravity(false);
            armorStand.setInvulnerable(true);
            armorStand.setGlowing(true);
            armorStand.setCustomName("\u00a7dEgg #" + key);
            armorStand.setCustomNameVisible(true);
            armorStand.setSmall(true);
            armorStand.setInvisible(true);
            Main.getInstance().getShowedArmorstands().add(armorStand);
            new BukkitRunnable(){
                int count = Main.getInstance().getConfig().getInt("Settings.ArmorstandGlow");

                public void run() {
                    --this.count;
                    if (this.count == 0) {
                        this.cancel();
                        for (ArmorStand a : Main.getInstance().getShowedArmorstands()) {
                            a.remove();
                            Main.getInstance().getShowedArmorstands().remove(a);
                        }
                    }
                }
            }.runTaskTimer((Plugin)Main.getInstance(), 0L, 20L);
        }
    }

    @Override
    public String getTopPlayerName() {
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (!Main.getInstance().eggs.contains("FoundEggs.")) {
            return "?????";
        }
        for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
        }
        if (leaderboard.size() < 1) {
            return "?????";
        }
        ArrayList leaderList = new ArrayList(leaderboard.entrySet());
        leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return (String)((Map.Entry)leaderList.get(0)).getKey();
    }

    @Override
    public int getTopPlayerEggsFound() {
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (!Main.getInstance().eggs.contains("FoundEggs.")) {
            return -1;
        }
        for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
        }
        if (leaderboard.size() < 1) {
            return -1;
        }
        ArrayList leaderList = new ArrayList(leaderboard.entrySet());
        leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return (Integer)((Map.Entry)leaderList.get(0)).getValue();
    }

    @Override
    public String getSecondPlayerName() {
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (!Main.getInstance().eggs.contains("FoundEggs.")) {
            return "?????";
        }
        for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
        }
        if (leaderboard.size() < 2) {
            return "?????";
        }
        ArrayList leaderList = new ArrayList(leaderboard.entrySet());
        leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return (String)((Map.Entry)leaderList.get(1)).getKey();
    }

    @Override
    public int getSecondPlayerEggsFound() {
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (!Main.getInstance().eggs.contains("FoundEggs.")) {
            return -1;
        }
        for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
        }
        if (leaderboard.size() < 2) {
            return -1;
        }
        ArrayList leaderList = new ArrayList(leaderboard.entrySet());
        leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return (Integer)((Map.Entry)leaderList.get(1)).getValue();
    }

    @Override
    public String getThirdPlayerName() {
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (!Main.getInstance().eggs.contains("FoundEggs.")) {
            return "?????";
        }
        for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
        }
        if (leaderboard.size() < 3) {
            return "?????";
        }
        ArrayList leaderList = new ArrayList(leaderboard.entrySet());
        leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return (String)((Map.Entry)leaderList.get(2)).getKey();
    }

    @Override
    public int getThirdPlayerEggsFound() {
        HashMap<String, Integer> leaderboard = new HashMap<String, Integer>();
        if (!Main.getInstance().eggs.contains("FoundEggs.")) {
            return -1;
        }
        for (String uuid : Main.getInstance().eggs.getConfigurationSection("FoundEggs.").getKeys(false)) {
            leaderboard.put(Main.getInstance().eggs.getString("FoundEggs." + uuid + ".Name"), Main.getInstance().eggs.getInt("FoundEggs." + uuid + ".Count"));
        }
        if (leaderboard.size() < 3) {
            return -1;
        }
        ArrayList leaderList = new ArrayList(leaderboard.entrySet());
        leaderList.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
        return (Integer)((Map.Entry)leaderList.get(2)).getValue();
    }
}

