/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.util.saveinventory;

import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class DatetimeUtils {
    public final String[] TIME_UNITS = new String[]{"YEAR", "MONTH", "WEEK", "DAY", "HOUR", "MINUTE", "SECOND"};
    public final int[] SECONDS_IN_UNIT = new int[]{31536000, 2592000, 604800, 86400, 3600, 60};
    public DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy").withZone(this.getZoneId());
    public DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(this.getZoneId());
    public DateTimeFormatter YEAR_FORMATTER = DateTimeFormatter.ofPattern("yyyy").withZone(this.getZoneId());

    public byte getCurrentDayOfMonth() {
        return (byte)Calendar.getInstance().get(5);
    }

    public String getRelativeDate(long secondsToAdd) {
        try {
            return ZonedDateTime.now().plusSeconds(secondsToAdd).format(this.DATE_FORMATTER);
        }
        catch (Exception var3) {
            return "\u00a7cNOT FOUND";
        }
    }

    public String getNowDate() {
        try {
            return ZonedDateTime.now().format(this.DATE_FORMATTER);
        }
        catch (Exception var1) {
            var1.printStackTrace();
            return "\u00a7cNOT FOUND";
        }
    }

    public String getNowTime() {
        try {
            return ZonedDateTime.now().format(this.TIME_FORMATTER);
        }
        catch (Exception var1) {
            var1.printStackTrace();
            return "\u00a7cNOT FOUND";
        }
    }

    public String getNowYear() {
        try {
            return ZonedDateTime.now().format(this.YEAR_FORMATTER);
        }
        catch (Exception var1) {
            var1.printStackTrace();
            return "\u00a7cNOT FOUND";
        }
    }

    public long getSeconds(String date) {
        try {
            return ZonedDateTime.parse(date, this.DATE_FORMATTER).toEpochSecond();
        }
        catch (Exception var2) {
            return -1L;
        }
    }

    public int[] getTimeValues(double seconds) {
        int[] values = new int[]{0, 0, 0, 0, 0, 0, 0};
        for (int unitIndex = 0; unitIndex <= 5; ++unitIndex) {
            int amountForUnit = (int)seconds / this.SECONDS_IN_UNIT[unitIndex];
            int n = unitIndex;
            values[n] = values[n] + amountForUnit;
            seconds -= (double)(amountForUnit * this.SECONDS_IN_UNIT[unitIndex]);
        }
        values[6] = values[6] + (int)Math.round(seconds);
        return values;
    }

    public String convertToSentence(double seconds) {
        int valueIndex;
        int[] values = this.getTimeValues(seconds);
        StringBuilder sentenceBuilder = new StringBuilder();
        for (valueIndex = 0; valueIndex <= 6; ++valueIndex) {
            int value = values[valueIndex];
            if (value <= 0) continue;
            Object valueMessage = this.TIME_UNITS[valueIndex];
            if (value > 1) {
                valueMessage = (String)valueMessage + "S";
            }
            sentenceBuilder.append(value).append(" ").append("\u00a7cNOT FOUND").append(" ");
        }
        valueIndex = sentenceBuilder.length();
        return valueIndex > 1 ? sentenceBuilder.deleteCharAt(valueIndex - 1).toString() : "0 \u00a7cNOT FOUND";
    }

    public String getTimeAgo(String date) {
        return this.convertToSentence(-this.getSecondsBetweenNowAndDate(date));
    }

    public long getSecondsBetweenNowAndDate(String date) {
        try {
            return Duration.between(ZonedDateTime.now(this.getZoneId()), ZonedDateTime.parse(date, this.DATE_FORMATTER)).getSeconds();
        }
        catch (Exception var2) {
            return -1L;
        }
    }

    public ZoneId getZoneId() {
        String time = "default";
        if (!time.equals("default")) {
            try {
                return ZoneId.of(time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ZoneId.systemDefault();
    }
}

