/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;

public class ItemBuilder {
    private ItemMeta itemMeta;
    private ItemStack itemStack;

    public ItemBuilder(Material mat) {
        this.itemStack = new ItemStack(mat);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder setDisplayname(String s) {
        this.itemMeta.setDisplayName(s);
        return this;
    }

    public ItemBuilder setLocalizedName(String s) {
        this.itemMeta.setLocalizedName(s);
        return this;
    }

    public ItemBuilder setOwner(String name) {
        SkullMeta skullMeta = (SkullMeta)this.itemMeta;
        skullMeta.setOwner(name);
        return this;
    }

    public ItemBuilder withGlow(boolean s) {
        if (s) {
            this.itemMeta.addEnchant(Enchantment.LURE, 1, true);
            this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return this;
    }

    public ItemBuilder setSoulbound(boolean soulbound) {
        if (soulbound) {
            this.itemMeta.getPersistentDataContainer().set(NamespacedKey.minecraft((String)"soulbound"), PersistentDataType.BYTE, (Object)1);
        }
        return this;
    }

    public ItemBuilder setLore(String ... s) {
        this.itemMeta.setLore(Arrays.asList(s));
        return this;
    }

    public ItemBuilder setUnbreakable(boolean s) {
        this.itemMeta.setUnbreakable(s);
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... s) {
        this.itemMeta.addItemFlags(s);
        return this;
    }

    public String toString() {
        return "ItemBuilder{itemMeta=" + this.itemMeta + ", itemStack=" + this.itemStack + "}";
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.itemMeta);
        return this.itemStack;
    }

    public ItemBuilder setSkullOwner(String texture) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.itemMeta;
            GameProfile profile = new GameProfile(UUID.randomUUID(), null);
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture));
            Field field = skullMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(skullMeta, profile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public ItemBuilder setColor(Color color) {
        try {
            LeatherArmorMeta armorMeta = (LeatherArmorMeta)this.itemMeta;
            armorMeta.setColor(color);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public ItemBuilder addEnchant(Enchantment ench, int level) {
        this.itemMeta.addEnchant(ench, level, true);
        return this;
    }
}

