/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.util;

import de.theredend2000.advancedegghunt.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigLocationUtil {
    private Main plugin;
    private Location location;
    private String root;

    public ConfigLocationUtil(Main plugin, Location location, String root) {
        this.plugin = plugin;
        this.location = location;
        this.root = root;
    }

    public void saveBlockLocation() {
        YamlConfiguration config = this.plugin.eggs;
        config.set(this.root + ".World", (Object)this.location.getWorld().getName());
        config.set(this.root + ".X", (Object)this.location.getBlockX());
        config.set(this.root + ".Y", (Object)this.location.getBlockY());
        config.set(this.root + ".Z", (Object)this.location.getBlockZ());
        config.set(this.root + ".Date", (Object)this.plugin.getDatetimeUtils().getNowDate());
        config.set(this.root + ".Time", (Object)this.plugin.getDatetimeUtils().getNowTime());
        this.plugin.saveEggs();
    }

    public Block loadBlockLocation() {
        YamlConfiguration config = this.plugin.eggs;
        if (config.contains(this.root)) {
            World world = Bukkit.getWorld((String)config.getString(this.root + ".World"));
            int x = this.plugin.getConfig().getInt(this.root + ".X");
            int y = this.plugin.getConfig().getInt(this.root + ".Y");
            int z = this.plugin.getConfig().getInt(this.root + ".Z");
            return new Location(world, (double)x, (double)y, (double)z).getBlock();
        }
        return null;
    }

    public ConfigLocationUtil(Main plugin, String root) {
        this(plugin, null, root);
    }

    public void saveLocation() {
        YamlConfiguration config = this.plugin.eggs;
        config.set(this.root + ".World", (Object)this.location.getWorld().getName());
        config.set(this.root + ".X", (Object)this.location.getX());
        config.set(this.root + ".Y", (Object)this.location.getY());
        config.set(this.root + ".Z", (Object)this.location.getZ());
        config.set(this.root + ".Yaw", (Object)Float.valueOf(this.location.getYaw()));
        config.set(this.root + ".Pitch", (Object)Float.valueOf(this.location.getPitch()));
        this.plugin.saveEggs();
    }

    public Location loadLocation() {
        YamlConfiguration config = this.plugin.eggs;
        if (config.contains(this.root)) {
            World world = Bukkit.getWorld((String)config.getString(this.root + ".World"));
            double x = config.getDouble(this.root + ".X");
            double y = config.getDouble(this.root + ".Y");
            double z = config.getDouble(this.root + ".Z");
            float yaw = (float)config.getDouble(this.root + ".Yaw");
            float pitch = (float)config.getDouble(this.root + ".Pitch");
            return new Location(world, x, y, z, yaw, pitch);
        }
        return null;
    }
}

