/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.listeners;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class BlockBreakEventListener
implements Listener {
    public BlockBreakEventListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Main.getInstance());
    }

    @EventHandler
    public void onDestroyEgg(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if ((block.getType() == Material.PLAYER_HEAD || block.getType() == Material.PLAYER_WALL_HEAD) && VersionManager.getEggManager().containsEgg(event.getBlock())) {
            String permission = Main.getInstance().getConfig().getString("Permissions.BreakEggPermission");
            if (player.hasPermission(permission)) {
                if (Main.getInstance().getPlaceEggsPlayers().contains(player)) {
                    VersionManager.getEggManager().removeEgg(player, block);
                    player.playSound(player.getLocation(), VersionManager.getSoundManager().playEggBreakSound(), (float)VersionManager.getSoundManager().getSoundVolume(), 1.0f);
                } else {
                    player.sendMessage(Main.getInstance().getMessage("OnlyInPlaceMode"));
                    event.setCancelled(true);
                }
            } else {
                player.sendMessage(Main.getInstance().getMessage("NoPermissionMessage").replaceAll("%PERMISSION%", permission));
                event.setCancelled(true);
            }
        }
    }
}

