/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt.commands;

import de.theredend2000.advancedegghunt.Main;
import de.theredend2000.advancedegghunt.util.ItemBuilder;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.eggfoundrewardmenu.EggRewardMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.eggprogress.EggProgressMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.hintInventory.HintInventoryCreator;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.leaderboardmenu.EggLeaderboardMenu;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.EggListMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;

public class AdvancedEggHuntCommand
implements CommandExecutor,
TabCompleter {
    private final String permission = Main.getInstance().getConfig().getString("Permissions.AdvancedEggHuntCommandPermission");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            assert (this.permission != null);
            if (player.hasPermission(this.permission)) {
                if (args.length == 1) {
                    if (args[0].equalsIgnoreCase("placeEggs")) {
                        if (Main.getInstance().getPlaceEggsPlayers().contains(player)) {
                            VersionManager.getEggManager().finishEggPlacing(player);
                            Main.getInstance().getPlaceEggsPlayers().remove(player);
                            player.sendMessage(Main.getInstance().getMessage("LeftPlaceMode"));
                        } else {
                            VersionManager.getEggManager().startEggPlacing(player);
                            Main.getInstance().getPlaceEggsPlayers().add(player);
                            player.sendMessage(Main.getInstance().getMessage("EnterPlaceMode"));
                            player.getInventory().setItem(4, new ItemBuilder(Material.NETHER_STAR).setDisplayname("\u00a76\u00a7lEggs Types \u00a77(Right-Click)").setLocalizedName("egghunt.eggs").build());
                            player.getInventory().setItem(8, new ItemBuilder(Material.PLAYER_HEAD).setSkullOwner(Main.getTexture("YTkyZTMxZmZiNTljOTBhYjA4ZmM5ZGMxZmUyNjgwMjAzNWEzYTQ3YzQyZmVlNjM0MjNiY2RiNDI2MmVjYjliNiJ9fX0=")).setDisplayname("\u00a72\u00a7lFinish setup \u00a77(Drop)").setLore("\u00a77Drop to finish the setup", "\u00a77or type \u00a7e/egghunt placeEggs \u00a77again.").setLocalizedName("egghunt.finish").setSoulbound(true).build());
                        }
                    } else if (args[0].equalsIgnoreCase("list")) {
                        new EggListMenu(Main.getPlayerMenuUtility(player)).open();
                    } else if (args[0].equalsIgnoreCase("show")) {
                        VersionManager.getEggManager().showAllEggs();
                        player.sendMessage(Main.getInstance().getMessage("EggsVisible").replaceAll("%TIME_VISIBLE%", String.valueOf(Main.getInstance().getConfig().getInt("Settings.ArmorstandGlow"))));
                    } else if (args[0].equalsIgnoreCase("reload")) {
                        Main.getInstance().reloadConfig();
                        Main.getInstance().checkCommandFeedback();
                        player.sendMessage(Main.getInstance().getMessage("ReloadedConfig"));
                    } else if (args[0].equalsIgnoreCase("help")) {
                        this.sendHelp(player);
                    } else if (args[0].equalsIgnoreCase("settings")) {
                        VersionManager.getInventoryManager().createEggsSettingsInventory(player);
                    } else if (args[0].equalsIgnoreCase("progress")) {
                        new EggProgressMenu(Main.getPlayerMenuUtility(player)).open();
                    } else if (args[0].equalsIgnoreCase("commands")) {
                        new EggRewardMenu(Main.getPlayerMenuUtility(player)).open();
                    } else if (args[0].equalsIgnoreCase("leaderboard")) {
                        new EggLeaderboardMenu(Main.getPlayerMenuUtility(player)).open();
                    } else if (args[0].equalsIgnoreCase("admin")) {
                        if (player.getName().equals("TheRedEnd2000")) {
                            new HintInventoryCreator(player, Bukkit.createInventory((InventoryHolder)player, (int)54, (String)"Eggs Hint"), true);
                        }
                    } else {
                        player.sendMessage(this.usage());
                    }
                } else {
                    player.sendMessage(this.usage());
                }
            } else if (args.length == 1) {
                if (args[0].equalsIgnoreCase("progress")) {
                    new EggProgressMenu(Main.getPlayerMenuUtility(player)).open();
                } else if (args[0].equalsIgnoreCase("leaderboard")) {
                    new EggLeaderboardMenu(Main.getPlayerMenuUtility(player)).open();
                } else {
                    player.sendMessage(Main.getInstance().getMessage("NoPermissionMessage").replaceAll("%PERMISSION%", this.permission));
                }
            } else {
                player.sendMessage(Main.getInstance().getMessage("NoPermissionMessage").replaceAll("%PERMISSION%", this.permission));
            }
        } else {
            sender.sendMessage(Main.getInstance().getMessage("OnlyPlayerCanUseThisCommandMessage"));
        }
        return false;
    }

    private String usage() {
        return Main.getInstance().getMessage("AdvancedEggHuntCommandUsageMessage");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            if (sender.hasPermission(this.permission)) {
                String[] tabs = new String[]{"placeEggs", "reload", "list", "help", "settings", "progress", "show", "commands", "leaderboard"};
                ArrayList<String> complete = new ArrayList<String>();
                Collections.addAll(complete, tabs);
                return complete;
            }
            String[] tabs = new String[]{"progress", "leaderboard"};
            ArrayList<String> complete = new ArrayList<String>();
            Collections.addAll(complete, tabs);
            return complete;
        }
        if (args.length >= 2) {
            ArrayList<String> complete = new ArrayList<String>();
            return complete;
        }
        return null;
    }

    private void sendHelp(Player player) {
        player.sendMessage("\u00a73-----------------------------------------");
        player.sendMessage("\u00a75\u00a7l==========HELP==========");
        player.sendMessage("");
        player.sendMessage("\u00a72\u00a7lInformation");
        player.sendMessage("\u00a77Name: \u00a76" + Main.getInstance().getDescription().getName());
        player.sendMessage("\u00a77Plugin Version: \u00a76" + Main.getInstance().getDescription().getVersion());
        player.sendMessage("\u00a77Api Version: \u00a76" + Main.getInstance().getDescription().getAPIVersion());
        player.sendMessage("\u00a77Server Version: \u00a76" + Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3]);
        player.sendMessage("\u00a77Author: \u00a76XMC-PLUGINS");
        player.sendMessage("");
        player.sendMessage("\u00a72\u00a7lCommands");
        player.sendMessage("\u00a76/advancedegghunt help \u00a77-> \u00a7bShows this help messages and information.");
        player.sendMessage("\u00a76/advancedegghunt reload \u00a77-> \u00a7bReloads the config.");
        player.sendMessage("\u00a76/advancedegghunt list \u00a77-> \u00a7bLists all placed eggs.");
        player.sendMessage("\u00a76/advancedegghunt placeEggs \u00a77-> \u00a7bEnter Place-Mode the place or break eggs.");
        player.sendMessage("\u00a76/advancedegghunt settings \u00a77-> \u00a7bConfigure many settings of the plugin.");
        player.sendMessage("\u00a76/advancedegghunt progress \u00a77-> \u00a7bView your progress of the eggs.");
        player.sendMessage("\u00a76/advancedegghunt show \u00a77-> \u00a7bSpawns an glowing armorstand at every egg.");
        player.sendMessage("\u00a76/advancedegghunt commands \u00a77-> \u00a7bChange commands or add more.");
        player.sendMessage("\u00a75\u00a7l==========HELP==========");
        player.sendMessage("\u00a73-----------------------------------------");
    }
}

