/*
 * Decompiled with CFR 0.152.
 */
package de.theredend2000.advancedegghunt;

import de.theredend2000.advancedegghunt.commands.AdvancedEggHuntCommand;
import de.theredend2000.advancedegghunt.listeners.BlockBreakEventListener;
import de.theredend2000.advancedegghunt.listeners.BlockPlaceEventListener;
import de.theredend2000.advancedegghunt.listeners.EntityChangeListener;
import de.theredend2000.advancedegghunt.listeners.ExplodeEventListener;
import de.theredend2000.advancedegghunt.listeners.InventoryClickEventListener;
import de.theredend2000.advancedegghunt.listeners.PlayerChatEventListener;
import de.theredend2000.advancedegghunt.listeners.PlayerConnectionListener;
import de.theredend2000.advancedegghunt.listeners.PlayerInteractEventListener;
import de.theredend2000.advancedegghunt.listeners.PlayerInteractItemEvent;
import de.theredend2000.advancedegghunt.placeholderapi.PlaceholderExtension;
import de.theredend2000.advancedegghunt.util.Updater;
import de.theredend2000.advancedegghunt.util.enums.LeaderboardSortTypes;
import de.theredend2000.advancedegghunt.util.saveinventory.DatetimeUtils;
import de.theredend2000.advancedegghunt.versions.VersionManager;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.hintInventory.HintInventoryCreator;
import de.theredend2000.advancedegghunt.versions.managers.inventorymanager.paginatedMenu.PlayerMenuUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static Main plugin;
    private DatetimeUtils datetimeUtils;
    private Map<String, Long> refreshCooldown;
    private ArrayList<Player> placeEggsPlayers;
    private HashMap<Player, Integer> playerAddCommand;
    private ArrayList<ArmorStand> showedArmorstands;
    public YamlConfiguration messages;
    public File messagesData;
    public YamlConfiguration eggs;
    private HashMap<Player, LeaderboardSortTypes> sortTypeLeaderboard;
    private File data = new File(this.getDataFolder(), "eggs.yml");
    private static final HashMap<Player, PlayerMenuUtility> playerMenuUtilityMap;

    public void onEnable() {
        plugin = this;
        this.refreshCooldown = new HashMap<String, Long>();
        this.placeEggsPlayers = new ArrayList();
        this.showedArmorstands = new ArrayList();
        this.playerAddCommand = new HashMap();
        this.sortTypeLeaderboard = new HashMap();
        this.setupConfigs();
        VersionManager.registerAllManagers();
        this.getCommand("advancedegghunt").setExecutor((CommandExecutor)new AdvancedEggHuntCommand());
        this.initListeners();
        this.datetimeUtils = new DatetimeUtils();
        VersionManager.getEggManager().spawnEggParticle();
        this.checkCommandFeedback();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            Bukkit.getConsoleSender().sendMessage(this.messages.getString("Prefix").replaceAll("&", "\u00a7") + "\u00a7aAdvanced Egg Hunt detected PlaceholderAPI, enabling placeholders.");
            new PlaceholderExtension().register();
            Bukkit.getConsoleSender().sendMessage(this.messages.getString("Prefix").replaceAll("&", "\u00a7") + "\u00a72\u00a7lAll placeholders successfully enabled.");
        }
    }

    public void onDisable() {
        this.giveAllItemsBack();
        for (ArmorStand a : this.showedArmorstands) {
            a.remove();
        }
        Main.getInstance().eggs.set("Edit", null);
        Main.getInstance().saveEggs();
    }

    public void checkCommandFeedback() {
        if (this.getConfig().getBoolean("Settings.DisableCommandFeedback")) {
            for (World worlds : Bukkit.getServer().getWorlds()) {
                worlds.setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)false);
            }
        } else {
            for (World worlds : Bukkit.getServer().getWorlds()) {
                worlds.setGameRule(GameRule.SEND_COMMAND_FEEDBACK, (Object)true);
            }
        }
    }

    private void initListeners() {
        new InventoryClickEventListener();
        new BlockPlaceEventListener();
        new BlockBreakEventListener();
        new PlayerInteractEventListener();
        new PlayerInteractItemEvent();
        new Updater(this);
        new PlayerChatEventListener();
        new ExplodeEventListener();
        new PlayerConnectionListener();
        new EntityChangeListener();
        new HintInventoryCreator(null, null, false);
        Bukkit.getConsoleSender().sendMessage(this.getMessage("Prefix").replaceAll("&", "\u00a7") + "\u00a7aAll Listeners registered.");
    }

    private void giveAllItemsBack() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.placeEggsPlayers.contains(player)) continue;
            VersionManager.getEggManager().finishEggPlacing(player);
        }
    }

    private void setupConfigs() {
        this.saveDefaultConfig();
        this.messagesData = new File(this.getDataFolder(), "messages.yml");
        try {
            if (!this.messagesData.exists()) {
                InputStream in = this.getResource("messages.yml");
                assert (in != null);
                Files.copy(in, this.messagesData.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesData);
        this.saveMessages();
        this.eggs = YamlConfiguration.loadConfiguration((File)this.data);
        this.saveEggs();
        this.checkUpdatePath();
    }

    private void checkUpdatePath() {
        if (!this.messages.contains("EggsNearbyRadiusOnlyBetween")) {
            this.messagesData.delete();
            this.setupConfigs();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                player.sendMessage(Main.getInstance().getMessage("Prefix").replaceAll("&", "\u00a7") + "\u00a7cBecause of a newer version, your files got reinstalled. Please check your messages.yml again.");
            }
            Bukkit.getConsoleSender().sendMessage(Main.getInstance().getMessage("Prefix").replaceAll("&", "\u00a7") + "\u00a7cBecause of a newer version, your files got reinstalled. Please check your messages.yml again.");
        }
        if (!this.getConfig().contains("PlaceEggs")) {
            File configFile = new File(this.getDataFolder(), "config.yml");
            configFile.delete();
            this.saveDefaultConfig();
            this.reloadConfig();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.isOp()) continue;
                player.sendMessage(Main.getInstance().getMessage("Prefix").replaceAll("&", "\u00a7") + "\u00a7cBecause of a newer version, your files got reinstalled. Please check your config.yml again.");
            }
            Bukkit.getConsoleSender().sendMessage(Main.getInstance().getMessage("Prefix").replaceAll("&", "\u00a7") + "\u00a7cBecause of a newer version, your files got reinstalled. Please check your config.yml again.");
        }
    }

    public void saveMessages() {
        try {
            this.messages.save(this.messagesData);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public void saveEggs() {
        try {
            this.eggs.save(this.data);
        }
        catch (IOException var2) {
            var2.printStackTrace();
        }
    }

    public Material getMaterial(String materialString) {
        try {
            Material material = Material.getMaterial((String)materialString);
            if (material == null) {
                return Material.BARRIER;
            }
            return material;
        }
        catch (Exception ex) {
            Bukkit.getConsoleSender().sendMessage("\u00a74Material Error: " + ex);
            return Material.STONE;
        }
    }

    public static Main getInstance() {
        return plugin;
    }

    public static String getTexture(String texture) {
        String prefix = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUv";
        texture = prefix + (String)texture;
        return texture;
    }

    public String getMessage(String message) {
        if (this.getConfig().getBoolean("Settings.PluginPrefixEnabled")) {
            return this.messages.getString("Prefix").replace("&", "\u00a7") + this.messages.getString(message).replace("&", "\u00a7");
        }
        return this.messages.getString(message).replace("&", "\u00a7");
    }

    public static PlayerMenuUtility getPlayerMenuUtility(Player p) {
        if (!playerMenuUtilityMap.containsKey(p)) {
            PlayerMenuUtility playerMenuUtility = new PlayerMenuUtility(p);
            playerMenuUtilityMap.put(p, playerMenuUtility);
            return playerMenuUtility;
        }
        return playerMenuUtilityMap.get(p);
    }

    public ArrayList<Player> getPlaceEggsPlayers() {
        return this.placeEggsPlayers;
    }

    public Map<String, Long> getRefreshCooldown() {
        return this.refreshCooldown;
    }

    public DatetimeUtils getDatetimeUtils() {
        return this.datetimeUtils;
    }

    public ArrayList<ArmorStand> getShowedArmorstands() {
        return this.showedArmorstands;
    }

    public HashMap<Player, Integer> getPlayerAddCommand() {
        return this.playerAddCommand;
    }

    public HashMap<Player, LeaderboardSortTypes> getSortTypeLeaderboard() {
        return this.sortTypeLeaderboard;
    }

    static {
        playerMenuUtilityMap = new HashMap();
    }
}

