/*
 * Decompiled with CFR 0.152.
 */
package com.starza4tw.picturebook;

import com.starza4tw.picturebook.CommandHandler;
import com.starza4tw.picturebook.ConfigurationHandler;
import com.starza4tw.picturebook.FilterHandler;
import com.starza4tw.picturebook.Metrics;
import com.starza4tw.picturebook.UpdateHandler;
import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public static Logger logger = Logger.getLogger("Minecraft");
    private static Main plugin;

    public void onEnable() {
        plugin = this;
        this.getCommand("picturebook").setExecutor((CommandExecutor)new CommandHandler(this));
        this.getServer().getPluginManager().registerEvents((Listener)new FilterHandler(), (Plugin)this);
        ConfigurationHandler.checkForConfigurationUpdate();
        ConfigurationHandler.registerConfiguration();
        if (this.getConfig().getBoolean("allowMetrics", true)) {
            Main.initializeMetrics();
        }
        FilterHandler.renameTask.runTaskTimer((Plugin)this, 0L, this.getConfig().getInt("itemRenameTaskPeriod", 20));
        if (UpdateHandler.getLatestVersion() == Main.getInstance().getDescription().getVersion()) {
            logger.info(ChatColor.GOLD + "[Picturebook]" + ChatColor.BLUE + " Using Latest Version! Using Version: " + Main.getInstance().getDescription().getVersion());
        } else if (UpdateHandler.getLatestVersion() != Main.getInstance().getDescription().getVersion()) {
            logger.info(ChatColor.GOLD + "[Picturebook]" + ChatColor.BLUE + " Either you are using a dev. build, or an update was found! Found Version: " + UpdateHandler.getLatestVersion());
        }
        logger.info(ChatColor.GOLD + "[Picturebook]" + ChatColor.GREEN + " Picturebook " + this.getDescription().getVersion() + " has been enabled!");
    }

    public void onDisable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        logger.info(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " Picturebook " + this.getDescription().getVersion() + " has been disabled!");
    }

    public static void initializeMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)Main.getInstance());
            metrics.start();
        }
        catch (IOException exception) {
            logger.severe(ChatColor.GOLD + "[Picturebook] " + ChatColor.RED + exception);
        }
    }

    public static Main getInstance() {
        return plugin;
    }
}

