/*
 * Decompiled with CFR 0.152.
 */
package com.starza4tw.picturebook;

import com.starza4tw.picturebook.ConfigurationHandler;
import com.starza4tw.picturebook.Main;
import com.starza4tw.picturebook.UpdateHandler;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandHandler
implements CommandExecutor {
    public Integer pageNumber;
    public Integer endCount;
    public String formatLabel;
    private final Main plugin;

    public CommandHandler(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] arguments) {
        if (command.getName().equalsIgnoreCase("picturebook")) {
            if (arguments.length == 0 || arguments[0].equalsIgnoreCase("help")) {
                if (sender.hasPermission("picturebook.command")) {
                    sender.sendMessage(new String[]{ChatColor.GOLD + "[Picturebook (pb) - Help]", ChatColor.BLUE + "/picturebook add [Filter] [Replacement] - " + ChatColor.WHITE + "Adds a filter for Picturebook to search for.", ChatColor.BLUE + "/picturebook list (Page) - " + ChatColor.WHITE + "Lists filtered words and their replacements.", ChatColor.BLUE + "/picturebook reload - " + ChatColor.WHITE + "Reloads Picturebook's config.", ChatColor.BLUE + "/picturebook remove [Filter] " + ChatColor.WHITE + "Removes a Filter from Picturebook's Filter List.", ChatColor.BLUE + "/picturebook update - " + ChatColor.WHITE + "Check for updates of Picturebook.", ChatColor.BLUE + "/picturebook version - " + ChatColor.WHITE + "Lists basic information about Picturebook."});
                    return true;
                }
                if (!sender.hasPermission("picturebook.command")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            } else if (arguments[0].equalsIgnoreCase("add")) {
                if (sender.hasPermission("picturebook.add")) {
                    if (arguments != null && arguments.length == 3) {
                        this.plugin.getConfig().getConfigurationSection("Filter").set(arguments[1], (Object)arguments[2]);
                        this.plugin.saveConfig();
                        this.plugin.reloadConfig();
                        ConfigurationHandler.FilterList.clear();
                        ConfigurationHandler.registerConfiguration();
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.WHITE + " Added Replacement to Filter List!");
                        return true;
                    }
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " Please list two arguments after the command!");
                    return true;
                }
                if (!sender.hasPermission("picturebook.add")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            } else if (arguments[0].equalsIgnoreCase("list")) {
                if (sender.hasPermission("picturebook.list")) {
                    if (arguments.length >= 3) {
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " Please list the correct number of arguments!");
                        return true;
                    }
                    if (arguments.length == 1) {
                        this.pageNumber = 1;
                    } else if (arguments.length == 2) {
                        try {
                            this.pageNumber = Integer.parseInt(arguments[1]);
                        }
                        catch (NumberFormatException exception) {
                            sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " Please input an Integer greater than 0 for the page number!");
                            return true;
                        }
                    }
                    if ((double)this.pageNumber.intValue() <= Math.ceil((double)ConfigurationHandler.FilterList.size() / 10.0) && this.pageNumber != 0) {
                        this.endCount = ConfigurationHandler.valueArray.length > 10 * this.pageNumber - 1 && ConfigurationHandler.valueArray[10 * this.pageNumber - 1] != null ? Integer.valueOf(10 * this.pageNumber - 1) : Integer.valueOf(ConfigurationHandler.valueArray.length - 1);
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook] - Filter List");
                        int Count = 10 * (this.pageNumber - 1);
                        while (Count <= this.endCount) {
                            if (ChatColor.stripColor((String)ConfigurationHandler.valueArray[Count].toString()).length() == 0) {
                                this.formatLabel = "FORMAT TEST";
                            } else if (ChatColor.stripColor((String)ConfigurationHandler.valueArray[Count].toString()).length() > 0) {
                                this.formatLabel = "";
                            }
                            sender.sendMessage(String.valueOf(ConfigurationHandler.keyArray[Count].toString()) + ": " + ConfigurationHandler.valueArray[Count].toString() + this.formatLabel);
                            ++Count;
                        }
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook] " + ChatColor.WHITE + "Showing page " + ChatColor.GREEN + this.pageNumber + ChatColor.WHITE + "/" + ChatColor.RED + (int)Math.ceil((double)ConfigurationHandler.FilterList.size() / 10.0) + ChatColor.AQUA + " [" + ConfigurationHandler.FilterList.size() + " Total Replacements]");
                        return true;
                    }
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " Please input an Integer greater than 0 for the page number!");
                    return true;
                }
                if (!sender.hasPermission("picturebook.list")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            } else if (arguments[0].equalsIgnoreCase("reload")) {
                if (sender.hasPermission("picturebook.reload")) {
                    this.plugin.reloadConfig();
                    ConfigurationHandler.FilterList.clear();
                    ConfigurationHandler.registerConfiguration();
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.WHITE + " Reloaded Configuration File.");
                    return true;
                }
                if (!sender.hasPermission("picturebook.reload")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            } else if (arguments[0].equalsIgnoreCase("remove")) {
                if (sender.hasPermission("picturebook.remove")) {
                    if (arguments != null && arguments.length == 2) {
                        this.plugin.getConfig().getConfigurationSection("Filter").set(arguments[1], null);
                        this.plugin.saveConfig();
                        this.plugin.reloadConfig();
                        ConfigurationHandler.FilterList.clear();
                        ConfigurationHandler.registerConfiguration();
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.WHITE + " Removed Replacement from Filter List!");
                        return true;
                    }
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " Please list an argument after the command!");
                    return true;
                }
                if (!sender.hasPermission("picturebook.remove")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            } else if (arguments[0].equalsIgnoreCase("update")) {
                if (sender.hasPermission("picturebook.update")) {
                    if (UpdateHandler.getLatestVersion() == Main.getInstance().getDescription().getVersion()) {
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.BLUE + " Using Latest Version! Using Version: " + Main.getInstance().getDescription().getVersion());
                        return true;
                    }
                    if (UpdateHandler.getLatestVersion() != Main.getInstance().getDescription().getVersion()) {
                        sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.BLUE + " Either you are using a dev build, or an update was found! Found Version: " + UpdateHandler.getLatestVersion());
                        return true;
                    }
                } else if (!sender.hasPermission("picturebook.update")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            } else if (arguments[0].equalsIgnoreCase("version")) {
                if (sender.hasPermission("picturebook.version")) {
                    sender.sendMessage(new String[]{ChatColor.GOLD + "[Picturebook - Version]", ChatColor.BLUE + "Version: " + ChatColor.WHITE + this.plugin.getDescription().getVersion(), ChatColor.BLUE + "Author(s): " + ChatColor.WHITE + this.plugin.getDescription().getAuthors(), ChatColor.BLUE + "Website: " + ChatColor.WHITE + this.plugin.getDescription().getWebsite()});
                    return true;
                }
                if (!sender.hasPermission("picturebook.version")) {
                    sender.sendMessage(ChatColor.GOLD + "[Picturebook]" + ChatColor.RED + " You don't have the permission to do that!");
                    return true;
                }
            }
        }
        return false;
    }
}

