/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.AutoUpdater;
import rudynakodach.github.io.webhookintegrations.Commands.SendToWebhook;
import rudynakodach.github.io.webhookintegrations.Commands.SetWebhookURL;
import rudynakodach.github.io.webhookintegrations.Commands.WIActions;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerAdvancementCompleted;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerChat;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerDeath;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerJoin;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerKick;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerQuit;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.WebhookActions;
import rudynakodach.github.io.webhookintegrations.bukkit.Metrics;

public final class WebhookIntegrations
extends JavaPlugin {
    public static boolean isLatest = true;
    public static int currentBuildNumber = 37;

    public void onEnable() {
        new Metrics(this, 18509);
        this.saveDefaultConfig();
        this.getLogger().log(Level.INFO, "Hello, World!");
        if (!new File(this.getDataFolder(), "lang.yml").exists()) {
            this.saveResource("lang.yml", false);
        }
        this.getLogger().log(Level.INFO, "Initializing language...");
        File langFile = new File(this.getDataFolder(), "lang.yml");
        Locale locale = Locale.getDefault();
        String selectedLanguage = locale.toString();
        YamlConfiguration languageConfig = YamlConfiguration.loadConfiguration((File)langFile);
        Object object = this.getConfig().get("language-override");
        if (object instanceof String) {
            String languageOverride = (String)object;
            if (!languageConfig.contains(selectedLanguage)) {
                this.getLogger().log(Level.INFO, "Language override is set to a language that doesn't exist. Falling back to en_US. For all available languages see lang.yml.");
                selectedLanguage = "en_US";
            } else {
                this.getLogger().log(Level.INFO, "Language override set to: " + languageOverride);
                selectedLanguage = languageOverride;
            }
        } else {
            if (!languageConfig.contains(selectedLanguage)) {
                selectedLanguage = "en_US";
            }
            this.getLogger().log(Level.INFO, "Hooked to " + selectedLanguage);
        }
        LanguageConfiguration language = new LanguageConfiguration(selectedLanguage, languageConfig);
        this.getLogger().log(Level.INFO, language.getString("onStart.message"));
        if (this.getConfig().getBoolean("check-for-updates")) {
            this.getLogger().log(Level.INFO, language.getString("update.checking"));
            try {
                int receivedBuildNumber = new AutoUpdater(this).getLatestVersion();
                if (currentBuildNumber < receivedBuildNumber && receivedBuildNumber != -1) {
                    isLatest = false;
                    this.getLogger().log(Level.WARNING, "------------------------- WI -------------------------");
                    this.getLogger().log(Level.INFO, language.getString("update.updateFound"));
                    this.getLogger().log(Level.WARNING, "------------------------------------------------------");
                    if (this.getConfig().getBoolean("auto-update")) {
                        isLatest = new AutoUpdater(this).Update();
                    }
                } else {
                    this.getLogger().log(Level.INFO, language.getString("update.latest"));
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, language.getString("update.checkFailed") + e.getMessage());
            }
        }
        if (Objects.equals(Objects.requireNonNull(this.getConfig().getString("webhookUrl")).trim(), "")) {
            this.getLogger().log(Level.WARNING, language.getString("onStart.webhookEmpty"));
        }
        this.getLogger().log(Level.INFO, language.getString("onStart.registeringEvents"));
        onPlayerChat chatEvent = new onPlayerChat(this);
        this.getServer().getPluginManager().registerEvents((Listener)chatEvent, (Plugin)this);
        onPlayerJoin onPlayerJoinEvent = new onPlayerJoin(this);
        this.getServer().getPluginManager().registerEvents((Listener)onPlayerJoinEvent, (Plugin)this);
        onPlayerQuit playerQuitEvent = new onPlayerQuit(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerQuitEvent, (Plugin)this);
        onPlayerKick playerKick = new onPlayerKick(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerKick, (Plugin)this);
        onPlayerAdvancementCompleted onPlayerAdvancement = new onPlayerAdvancementCompleted(this);
        this.getServer().getPluginManager().registerEvents((Listener)onPlayerAdvancement, (Plugin)this);
        onPlayerDeath playerDeath = new onPlayerDeath(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerDeath, (Plugin)this);
        this.getLogger().log(Level.INFO, language.getString("onStart.eventRegisterFinish"));
        SetWebhookURL setWebhookUrlCommand = new SetWebhookURL(this.getConfig(), this);
        Objects.requireNonNull(this.getCommand("setUrl")).setExecutor((CommandExecutor)setWebhookUrlCommand);
        SendToWebhook sendToWebhookCommand = new SendToWebhook(this.getConfig(), this);
        Objects.requireNonNull(this.getCommand("send")).setExecutor((CommandExecutor)sendToWebhookCommand);
        WIActions resetConfig = new WIActions(this);
        Objects.requireNonNull(this.getCommand("wi")).setExecutor((CommandExecutor)resetConfig);
        this.getLogger().log(Level.INFO, language.getString("onStart.commandRegisterFinish"));
        if (this.getConfig().getBoolean("onServerStart.announce")) {
            this.sendStartMessage();
        }
    }

    public void onDisable() {
        if (this.getConfig().getBoolean("onServerStop.announce") && !Objects.requireNonNull(this.getConfig().getString("webhookUrl")).trim().equals("")) {
            this.sendStopMessage();
        }
        this.getLogger().log(Level.INFO, "this is my final message");
        this.getLogger().log(Level.INFO, "goodb ye");
    }

    private void sendStartMessage() {
        String json = this.getConfig().getString("onServerStart.messageJson");
        String serverIp = this.getServer().getIp();
        int slots = this.getServer().getMaxPlayers();
        String serverMotd = PlainTextComponentSerializer.plainText().serialize(this.getServer().motd());
        String serverName = this.getServer().getName();
        String serverVersion = this.getServer().getVersion();
        Boolean isOnlineMode = this.getServer().getOnlineMode();
        int playersOnline = this.getServer().getOnlinePlayers().size();
        if (json == null) {
            return;
        }
        json = json.replace("%time%", new SimpleDateFormat("HH:mm:ss").format(new Date())).replace("%serverIp%", serverIp).replace("%maxPlayers%", String.valueOf(slots)).replace("%serverMotd%", serverMotd).replace("%serverName%", serverName).replace("%serverVersion%", serverVersion).replace("%isOnlineMode%", String.valueOf(isOnlineMode)).replace("%playersOnline%", String.valueOf(playersOnline));
        new WebhookActions(this).SendSync(json);
    }

    private void sendStopMessage() {
        String serverIp = this.getServer().getIp();
        int slots = this.getServer().getMaxPlayers();
        String serverMotd = PlainTextComponentSerializer.plainText().serialize(this.getServer().motd());
        String serverName = this.getServer().getName();
        String serverVersion = this.getServer().getVersion();
        Boolean isOnlineMode = this.getServer().getOnlineMode();
        int playersOnline = this.getServer().getOnlinePlayers().size();
        String json = this.getConfig().getString("onServerStop.messageJson");
        if (json == null) {
            return;
        }
        json = json.replace("%time%", new SimpleDateFormat("HH:mm:ss").format(new Date())).replace("%serverIp%", serverIp).replace("%maxPlayers%", String.valueOf(slots)).replace("%serverMotd%", serverMotd).replace("%serverName%", serverName).replace("%serverVersion%", serverVersion).replace("%isOnlineMode%", String.valueOf(isOnlineMode)).replace("%playersOnline%", String.valueOf(playersOnline));
        new WebhookActions(this).SendSync(json);
    }
}

