/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;

public class WebhookActions {
    JavaPlugin plugin;

    public WebhookActions(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void SendAsync(final String json) {
        if (!this.plugin.getConfig().getBoolean("isEnabled")) {
            return;
        }
        if (!this.plugin.getConfig().contains("webhookUrl")) {
            this.plugin.getLogger().log(Level.SEVERE, LanguageConfiguration.get().getString("config.noWebhookUrl"));
            return;
        }
        final String webhookUrl = Objects.requireNonNull(this.plugin.getConfig().getString("webhookUrl")).trim();
        if (webhookUrl.equals("")) {
            this.plugin.getLogger().log(Level.WARNING, "Attempted to send a message to an empty webhook URL! Use /setUrl or disable the event in the config!");
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    URL url = new URL(webhookUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/json");
                    connection.setDoOutput(true);
                    OutputStream outputStream = connection.getOutputStream();
                    outputStream.write(json.getBytes());
                    outputStream.flush();
                    outputStream.close();
                    int responseCode = connection.getResponseCode();
                    if (responseCode >= 400) {
                        WebhookActions.this.plugin.getLogger().log(Level.WARNING, "Failed to send eventMessage to Discord webhook: " + connection.getResponseMessage());
                        WebhookActions.this.plugin.getLogger().log(Level.INFO, json);
                    }
                }
                catch (IOException e) {
                    WebhookActions.this.plugin.getLogger().warning("Failed to POST json to URL: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void SendSync(String json) {
        if (!this.plugin.getConfig().getBoolean("isEnabled")) {
            return;
        }
        if (!this.plugin.getConfig().contains("webhookUrl")) {
            this.plugin.getLogger().log(Level.SEVERE, LanguageConfiguration.get().getString("config.noWebhookUrl"));
            return;
        }
        String webhookUrl = Objects.requireNonNull(this.plugin.getConfig().getString("webhookUrl")).trim();
        if (webhookUrl.equals("")) {
            this.plugin.getLogger().log(Level.WARNING, "Attempted to send a message to an empty webhook URL! Use /setUrl or disable the event in the config!");
            return;
        }
        try {
            URL url = new URL(webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(json.getBytes());
            outputStream.flush();
            outputStream.close();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 400) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to send eventMessage to Discord webhook: " + connection.getResponseMessage());
                this.plugin.getLogger().log(Level.INFO, json);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to POST json to URL: " + e.getMessage());
        }
    }
}

