/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class onPlayerChat
implements Listener {
    JavaPlugin plugin;

    public onPlayerChat(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerChatEvent(AsyncChatEvent event) {
        if (!this.plugin.getConfig().getBoolean("onPlayerChat.announce")) {
            return;
        }
        boolean allowPlaceholdersInMessage = this.plugin.getConfig().getBoolean("onPlayerChat.allow-placeholders-in-message");
        String message = PlainTextComponentSerializer.plainText().serialize(event.message());
        String playerName = event.getPlayer().getName();
        String time = new SimpleDateFormat("HH:mm:ss").format(new Date());
        String playerWorldName = event.getPlayer().getWorld().getName();
        String json = this.plugin.getConfig().getString("onPlayerChat.messageJson");
        if (json == null) {
            return;
        }
        for (String key : this.plugin.getConfig().getConfigurationSection("censoring").getKeys(false)) {
            message = message.replace(key, String.valueOf(this.plugin.getConfig().get("censoring." + key)));
        }
        if (this.plugin.getConfig().getBoolean("remove-force-pings")) {
            message = message.replaceAll("<@[0-9]+>", "");
        }
        if (this.plugin.getConfig().getBoolean("remove-force-channel-pings")) {
            message = message.replaceAll("<#[0-9]+>", "");
        }
        if (message.trim().equalsIgnoreCase("")) {
            return;
        }
        if (allowPlaceholdersInMessage) {
            json = json.replace("$message$", message);
        }
        json = json.replace("$playersOnline$", String.valueOf(this.plugin.getServer().getOnlinePlayers().size())).replace("$maxPlayers$", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("$uuid$", event.getPlayer().getUniqueId().toString()).replace("$player$", playerName).replace("$time$", time).replace("$world$", playerWorldName);
        if (this.plugin.getServer().getPluginManager().getPermission("PlaceholderAPI") != null) {
            json = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)json);
        }
        if (!allowPlaceholdersInMessage) {
            json = json.replace("$message$", message);
        }
        new WebhookActions(this.plugin).SendAsync(json);
    }
}

