/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rudynakodach.github.io.webhookintegrations.AutoUpdater;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.WebhookIntegrations;

public class WIActions
implements CommandExecutor,
TabCompleter {
    JavaPlugin plugin;
    private final LanguageConfiguration language;

    public WIActions(JavaPlugin plugin) {
        this.plugin = plugin;
        this.language = LanguageConfiguration.get();
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!(commandSender instanceof Player)) {
            this.plugin.getLogger().log(Level.INFO, "This command is intended to be used in the game.");
            return true;
        }
        Player player = (Player)commandSender;
        if (command.getName().equalsIgnoreCase("wi") && args.length >= 1) {
            if (args[0].equalsIgnoreCase("reset")) {
                if (args[1].equalsIgnoreCase("confirm")) {
                    return this.resetConfirm(commandSender);
                }
                if (!player.hasPermission("webhookintegrations.config.reset")) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
                    return true;
                }
                commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.config.noConfirm")));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                return this.reload(commandSender);
            }
            if (args[0].equalsIgnoreCase("analyze")) {
                return this.analyze(commandSender);
            }
            if (args[0].equalsIgnoreCase("update")) {
                return this.update(commandSender);
            }
            if (args[0].equalsIgnoreCase("enable")) {
                return this.enable(commandSender);
            }
            if (args[0].equalsIgnoreCase("disable")) {
                return this.disable(commandSender);
            }
            if (args[0].equalsIgnoreCase("setlanguage")) {
                return this.setLanguage(commandSender, args);
            }
            if (args[0].equalsIgnoreCase("config") && args.length >= 3) {
                return this.setConfig(commandSender, args);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("wi")) {
            if (args.length == 1) {
                suggestions.add("setlanguage");
                suggestions.add("reset");
                suggestions.add("enable");
                suggestions.add("disable");
                suggestions.add("reload");
                suggestions.add("analyze");
                suggestions.add("update");
                suggestions.add("config");
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("reset")) {
                    suggestions.add("confirm");
                } else {
                    if (args[0].equalsIgnoreCase("setlanguage")) {
                        return this.language.getYamlConfig().getKeys(false).stream().toList();
                    }
                    if (args[0].equalsIgnoreCase("config")) {
                        suggestions.add("setvalue");
                        return suggestions;
                    }
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("config") && args[1].equalsIgnoreCase("setvalue")) {
                    return this.plugin.getConfig().getKeys(true).stream().toList();
                }
            } else if (args.length == 4 && args[0].equalsIgnoreCase("config") && args[1].equalsIgnoreCase("setvalue")) {
                if (!this.plugin.getConfig().contains(args[3])) {
                    return null;
                }
                Object value = this.plugin.getConfig().get(args[3]);
                if (value instanceof Boolean) {
                    suggestions.add("true");
                    suggestions.add("false");
                    return suggestions;
                }
            }
        }
        return suggestions;
    }

    @Contract(pure=true)
    @NotNull
    private String colorBoolean(Boolean b) {
        if (!b.booleanValue()) {
            return ChatColor.RED + ChatColor.BOLD + "false" + ChatColor.RESET;
        }
        return ChatColor.GREEN + ChatColor.BOLD + "true" + ChatColor.RESET;
    }

    private boolean analyze(CommandSender commandSender) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.analyze")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        commandSender.sendMessage(ChatColor.AQUA + "Analyzing config... To reload the config use /wi reload");
        String message = "auto-update: " + this.colorBoolean(this.plugin.getConfig().getBoolean("auto-update"));
        message = Objects.requireNonNull(this.plugin.getConfig().getString("webhookUrl")).trim().equalsIgnoreCase("") ? message + "\nwebhookUrl: " + ChatColor.RED + "unset\n" : message + "\nwebhookUrl: " + ChatColor.GREEN + "set\n";
        message = message + ChatColor.YELLOW + "EVENTS" + ChatColor.WHITE;
        message = message + "\nonStart: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onServerStart.announce"));
        message = message + "\nonStop: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onServerStop.announce"));
        message = message + "\nplayerJoin: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerJoin.announce"));
        message = message + "\nplayerQuit: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerQuit.announce"));
        message = message + "\nplayerKicked: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerKicked.announce"));
        message = message + "\nonAdvancementMade: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerAdvancementComplete.announce"));
        message = message + "\nplayerDeathPve: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerDeath.playerKilledByNPC.announce"));
        message = message + "\nPlayerDeathPvp: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerDeath.playerKilledByPlayer.announce"));
        commandSender.sendMessage(message);
        return true;
    }

    private boolean resetConfirm(CommandSender commandSender) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.config.reset")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        this.plugin.saveResource("config.yml", true);
        this.plugin.reloadConfig();
        return true;
    }

    private boolean reload(CommandSender commandSender) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.reload")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        this.plugin.reloadConfig();
        YamlConfiguration languageFile = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "lang.yml"));
        this.language.reload(languageFile);
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.config.reloadFinish")));
        return true;
    }

    private boolean update(CommandSender commandSender) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.update")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        AutoUpdater updater = new AutoUpdater(this.plugin);
        try {
            int latestVersion = updater.getLatestVersion();
            if (latestVersion > WebhookIntegrations.currentBuildNumber) {
                boolean success = updater.Update();
                if (success) {
                    commandSender.sendMessage(this.language.getString("commands.update.success"));
                } else {
                    commandSender.sendMessage(this.language.getString("commands.update.failed"));
                }
            } else if (latestVersion == -1) {
                commandSender.sendMessage(this.language.getString("commands.update.versionCheckFailed"));
            } else {
                commandSender.sendMessage(this.language.getString("commands.update.latest"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private boolean enable(CommandSender commandSender) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.enable")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        this.plugin.getConfig().set("isEnabled", (Object)true);
        this.plugin.reloadConfig();
        return true;
    }

    private boolean disable(CommandSender commandSender) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.disable")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        this.plugin.getConfig().set("isEnabled", (Object)false);
        this.plugin.reloadConfig();
        return true;
    }

    private boolean setLanguage(CommandSender commandSender, String[] args) {
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.setlanguage")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        String newLang = args[1];
        if (this.language.getYamlConfig().contains(newLang)) {
            this.language.setLanguage(newLang);
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.setLang.changed")));
        } else {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.setLang.notExists")));
        }
        return true;
    }

    private boolean setConfig(CommandSender commandSender, String[] args) {
        String message;
        Player player = (Player)commandSender;
        if (!player.hasPermission("webhookintegrations.config.setvalue")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.language.getString("commands.no-permission")));
            return true;
        }
        String path = args[2];
        Object value = args.length >= 4 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : null;
        Object oldValue = null;
        if (this.plugin.getConfig().contains(path)) {
            oldValue = this.plugin.getConfig().get(path);
            message = LanguageConfiguration.get().getString("commands.config.keyEdited");
        } else {
            message = LanguageConfiguration.get().getString("commands.config.keyCreated");
        }
        if (value == null) {
            message = LanguageConfiguration.get().getString("commands.config.keyRemoved");
        } else if (value.toString().equalsIgnoreCase("true")) {
            value = true;
        } else if (value.toString().equalsIgnoreCase("false")) {
            value = false;
        } else {
            try {
                value = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.plugin.getConfig().set(path, value);
        try {
            this.plugin.getConfig().save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (Exception e) {
            commandSender.sendMessage(LanguageConfiguration.get().getString("commands.config.saveFailed").replace("%04", e.getMessage()));
            return true;
        }
        message = message.replace("%01", path).replace("%02", value instanceof String ? String.format("\"%s\"", value) : String.valueOf(value));
        if (oldValue != null) {
            message = message.replace("%03", oldValue.toString());
        }
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        return true;
    }
}

