/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.AutoUpdater;
import rudynakodach.github.io.webhookintegrations.Commands.SendToWebhook;
import rudynakodach.github.io.webhookintegrations.Commands.SetWebhookURL;
import rudynakodach.github.io.webhookintegrations.Commands.WIActions;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerAdvancementCompleted;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerChat;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerDeath;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerJoin;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerKick;
import rudynakodach.github.io.webhookintegrations.Events.onPlayerQuit;

public final class WebhookIntegrations
extends JavaPlugin {
    public static boolean isLatest = true;
    public static int currentBuildNumber = 28;
    public static String localeLang;
    public static FileConfiguration lang;

    public void onEnable() {
        this.getLogger().log(Level.INFO, "Hello, World!");
        if (!new File(this.getDataFolder(), "lang.yml").exists()) {
            this.saveResource("lang.yml", false);
        }
        if (!new File(this.getDataFolder(), "advancements.yml").exists()) {
            this.saveResource("advancements.yml", false);
        }
        File langFile = new File(this.getDataFolder(), "lang.yml");
        lang = YamlConfiguration.loadConfiguration((File)langFile);
        this.getLogger().log(Level.INFO, "Initializing language...");
        this.saveDefaultConfig();
        Locale locale = Locale.getDefault();
        localeLang = locale.toString();
        if (!lang.contains(localeLang)) {
            localeLang = "en_US";
        }
        this.getLogger().log(Level.INFO, "Hooked to " + localeLang);
        if (this.getConfig().getBoolean("check-for-updates")) {
            this.getLogger().log(Level.INFO, lang.getString(localeLang + ".update.checking"));
            try {
                int receivedBuildNumber = new AutoUpdater(this).getLatestVersion();
                if (currentBuildNumber < receivedBuildNumber && receivedBuildNumber != -1) {
                    isLatest = false;
                    this.getLogger().log(Level.WARNING, "Current: " + currentBuildNumber + " | New: " + receivedBuildNumber);
                    this.getLogger().log(Level.WARNING, "------------------------- WI -------------------------");
                    this.getLogger().log(Level.INFO, lang.getString(localeLang + ".update.updateFound"));
                    this.getLogger().log(Level.WARNING, "------------------------------------------------------");
                    if (this.getConfig().getBoolean("auto-update")) {
                        isLatest = new AutoUpdater(this).Update();
                    }
                } else {
                    this.getLogger().log(Level.INFO, lang.getString(localeLang + ".update.latest"));
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, lang.getString(localeLang + ".update.checkFailed") + e.getMessage());
            }
        }
        this.saveDefaultConfig();
        if (Objects.equals(Objects.requireNonNull(this.getConfig().getString("webhookUrl")).trim(), "")) {
            this.getLogger().log(Level.WARNING, lang.getString(localeLang + ".onStart.webhookEmpty"));
        }
        this.getLogger().log(Level.INFO, lang.getString(localeLang + ".onStart.registeringEvents"));
        onPlayerChat chatEvent = new onPlayerChat(this);
        this.getServer().getPluginManager().registerEvents((Listener)chatEvent, (Plugin)this);
        onPlayerJoin onPlayerJoinEvent = new onPlayerJoin(this);
        this.getServer().getPluginManager().registerEvents((Listener)onPlayerJoinEvent, (Plugin)this);
        onPlayerQuit playerQuitEvent = new onPlayerQuit(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerQuitEvent, (Plugin)this);
        onPlayerKick playerKick = new onPlayerKick(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerKick, (Plugin)this);
        onPlayerAdvancementCompleted onPlayerAdvancement = new onPlayerAdvancementCompleted(this);
        this.getServer().getPluginManager().registerEvents((Listener)onPlayerAdvancement, (Plugin)this);
        onPlayerDeath playerDeath = new onPlayerDeath(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerDeath, (Plugin)this);
        this.getLogger().log(Level.INFO, lang.getString(localeLang + ".onStart.eventRegisterFinish"));
        SetWebhookURL setWebhookUrlCommand = new SetWebhookURL(this.getConfig(), this);
        Objects.requireNonNull(this.getCommand("setUrl")).setExecutor((CommandExecutor)setWebhookUrlCommand);
        SendToWebhook sendToWebhookCommand = new SendToWebhook(this.getConfig(), this, this.getLogger());
        Objects.requireNonNull(this.getCommand("send")).setExecutor((CommandExecutor)sendToWebhookCommand);
        WIActions resetConfig = new WIActions(this);
        Objects.requireNonNull(this.getCommand("wi")).setExecutor((CommandExecutor)resetConfig);
        this.getLogger().log(Level.INFO, lang.getString(localeLang + ".onStart.commandRegisterFinish"));
    }

    public void onDisable() {
        if (this.getConfig().getBoolean("onServerStop.announce") && !this.getConfig().getString("webhookUrl").trim().equals("")) {
            String serverIp = this.getServer().getIp();
            int slots = this.getServer().getMaxPlayers();
            String serverMotd = this.getServer().getMotd();
            String serverName = this.getServer().getName();
            String serverVersion = this.getServer().getVersion();
            Boolean isOnlineMode = this.getServer().getOnlineMode();
            int playersOnline = this.getServer().getOnlinePlayers().size();
            String json = this.getConfig().getString("onServerStop.messageJson");
            json = json.replace("%time%", new SimpleDateFormat("HH:mm:ss").format(new Date()));
            json = json.replace("%serverIp%", serverIp);
            json = json.replace("%maxPlayers%", String.valueOf(slots));
            json = json.replace("%serverMotd%", serverMotd);
            json = json.replace("%serverName%", serverName);
            json = json.replace("%serverVersion%", serverVersion);
            json = json.replace("%isOnlineMode%", String.valueOf(isOnlineMode));
            json = json.replace("%playersOnline%", String.valueOf(playersOnline));
            try {
                URL url = new URL(this.getConfig().getString("webhookUrl"));
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (connection.getResponseCode() == 200) {
                    OutputStream outputStream = connection.getOutputStream();
                    outputStream.write(json.getBytes());
                    outputStream.flush();
                    outputStream.close();
                    connection.getResponseCode();
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, "Failed to send server stop message: " + e.getMessage());
            }
        }
        this.getLogger().log(Level.INFO, "this is my final message");
        this.getLogger().log(Level.INFO, "goodb ye");
    }
}

