/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rudynakodach.github.io.webhookintegrations.AutoUpdater;
import rudynakodach.github.io.webhookintegrations.WebhookIntegrations;

public class WIActions
implements CommandExecutor,
TabCompleter {
    JavaPlugin plugin;

    public WIActions(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        block24: {
            if (!(commandSender instanceof Player)) {
                this.plugin.getLogger().log(Level.INFO, "This command is intended to be used in the game.");
                return true;
            }
            Player player = (Player)commandSender;
            if (command.getName().equalsIgnoreCase("wi") && args.length >= 1) {
                if (args[0].equalsIgnoreCase("reset")) {
                    if (args[1].equalsIgnoreCase("confirm")) {
                        if (!player.hasPermission("webhookintegrations.config.reset")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.no-permission")));
                            return true;
                        }
                        this.plugin.saveResource("config.yml", true);
                        this.plugin.reloadConfig();
                        return true;
                    }
                    commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.config.noConfirm")));
                } else {
                    if (args[0].equalsIgnoreCase("reload")) {
                        if (!player.hasPermission("webhookintegrations.reload")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.no-permission")));
                            return true;
                        }
                        this.plugin.reloadConfig();
                        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.config.reloadFinish")));
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("analyze")) {
                        if (!player.hasPermission("webhookintegrations.analyze")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.no-permission")));
                            return true;
                        }
                        commandSender.sendMessage(ChatColor.AQUA + "Analyzing config... To reload the config use /wi reload");
                        StringBuilder message = new StringBuilder("auto-update: " + this.colorBoolean(this.plugin.getConfig().getBoolean("auto-update")));
                        if (this.plugin.getConfig().getString("webhookUrl").trim().equalsIgnoreCase("")) {
                            message.append("\nwebhookUrl: " + ChatColor.RED + "unset\n");
                        } else {
                            message.append("\nwebhookUrl: " + ChatColor.GREEN + "set\n");
                        }
                        message.append(ChatColor.YELLOW + "EVENTS").append("\nonStart: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onServerStart.announce"))).append("\nonStop: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onServerStop.announce"))).append("\nplayerJoin: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerJoin.announce"))).append("\nplayerQuit: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerQuit.announce"))).append("\nplayerKicked: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerKicked.announce"))).append("\nonAdvancementMade: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerAdvancementComplete.announce"))).append("\nplayerDeathPve: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerDeath.playerKilledByNPC.announce"))).append("\nPlayerDeathPvp: " + this.colorBoolean(this.plugin.getConfig().getBoolean("onPlayerDeath.playerKilledByPlayer.announce")));
                        commandSender.sendMessage(String.valueOf(message));
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("update")) {
                        if (!player.hasPermission("webhookintegrations.update")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.no-permission")));
                            return true;
                        }
                        AutoUpdater updater = new AutoUpdater(this.plugin);
                        try {
                            if (updater.getLatestVersion() > WebhookIntegrations.currentBuildNumber) {
                                boolean success = updater.Update();
                                if (success) {
                                    commandSender.sendMessage(WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.update.success"));
                                } else {
                                    commandSender.sendMessage(WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.update.failed"));
                                }
                                break block24;
                            }
                            commandSender.sendMessage(WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".update.latest"));
                        }
                        catch (IOException iOException) {}
                    } else {
                        if (args[0].equalsIgnoreCase("enable")) {
                            if (!player.hasPermission("webhookintegrations.enable")) {
                                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.no-permission")));
                                return true;
                            }
                            this.plugin.getConfig().set("isEnabled", (Object)true);
                            this.plugin.reloadConfig();
                            return true;
                        }
                        if (args[0].equalsIgnoreCase("disable")) {
                            if (!player.hasPermission("webhookintegrations.disable")) {
                                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.no-permission")));
                                return true;
                            }
                            this.plugin.getConfig().set("isEnabled", (Object)false);
                            this.plugin.reloadConfig();
                            return true;
                        }
                    }
                }
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("wi")) {
            if (args.length == 0) {
                suggestions.add("reset");
                suggestions.add("reload");
                suggestions.add("analyze");
                return suggestions;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reset")) {
                suggestions.add("confirm");
                return suggestions;
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    private String colorBoolean(Boolean b) {
        if (!b.booleanValue()) {
            return ChatColor.RED + String.valueOf(false);
        }
        return ChatColor.GREEN + String.valueOf(true);
    }
}

