/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Commands;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.WebhookIntegrations;

public class SetWebhookURL
implements CommandExecutor {
    final FileConfiguration config;
    final JavaPlugin javaPlugin;
    final Logger logger;

    public SetWebhookURL(FileConfiguration _cfg, JavaPlugin _javaPlugin) {
        this.config = _cfg;
        this.javaPlugin = _javaPlugin;
        this.logger = this.javaPlugin.getLogger();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("seturl")) {
            if (args.length == 1) {
                String newUrl = args[0].trim();
                if (!newUrl.startsWith("https://")) {
                    sender.sendMessage(ChatColor.RED + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.noHttps"));
                    return true;
                }
                if (!newUrl.contains("discord")) {
                    sender.sendMessage(ChatColor.RED + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.notDiscord"));
                    return true;
                }
                sender.sendMessage(ChatColor.BLUE + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.verifyStart"));
                try {
                    int responseCode = this.getResponseCode(newUrl);
                    if (responseCode != 200 && responseCode != 204) {
                        sender.sendMessage(ChatColor.LIGHT_PURPLE + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.verifyFail"));
                        return true;
                    }
                    sender.sendMessage(ChatColor.GREEN + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.verifySuccess"));
                }
                catch (IOException e) {
                    sender.sendMessage(ChatColor.RED + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.verifyFail"));
                    return true;
                }
                this.config.set("webhookUrl", (Object)newUrl);
                this.javaPlugin.saveConfig();
                sender.sendMessage(ChatColor.GREEN + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.newUrlSet"));
                return true;
            }
            sender.sendMessage(ChatColor.LIGHT_PURPLE + WebhookIntegrations.lang.getString(WebhookIntegrations.localeLang + ".commands.seturl.commandIncorrectUsage"));
            return false;
        }
        return false;
    }

    private int getResponseCode(String target) throws IOException {
        String json = "{\"content\": \"**Connected!**\"}";
        URL url = new URL(target);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(json.getBytes());
        outputStream.flush();
        outputStream.close();
        return connection.getResponseCode();
    }
}

