/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.WebhookIntegrations;

public class AutoUpdater {
    static String downloadLinkUrl = "https://raw.githubusercontent.com/rudynakodach/WebhookIntegrations/master/downloadurl";
    static String filenameUrl = "https://raw.githubusercontent.com/rudynakodach/WebhookIntegrations/master/filename";
    static String buildNumberUrl = "https://raw.githubusercontent.com/rudynakodach/WebhookIntegrations/master/buildnumber";
    final JavaPlugin plugin;

    public AutoUpdater(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean Update() {
        try {
            String newFilename;
            String downloadUrl = this.getDownloadUrl();
            this.plugin.getLogger().log(Level.INFO, "Release URL: " + downloadUrl);
            byte[] data = this.getLatestFile(downloadUrl);
            if (data == null) {
                this.plugin.getLogger().log(Level.SEVERE, "Received plugin data was null.");
                return false;
            }
            this.plugin.getLogger().log(Level.INFO, "Plugin data received.");
            String destination = this.plugin.getServer().getUpdateFolderFile().getAbsolutePath();
            File updateFolder = new File(destination);
            if (!updateFolder.exists()) {
                updateFolder.mkdir();
            }
            if ((newFilename = this.getLatestFilename()) == null) {
                this.plugin.getLogger().log(Level.SEVERE, "Received filename was null.");
                return false;
            }
            File file = new File(destination, newFilename);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(data);
            fos.close();
            this.plugin.getLogger().log(Level.INFO, "New version downloaded to " + file.getPath());
            return true;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Update failed: " + e.getMessage());
            WebhookIntegrations.isLatest = false;
            return false;
        }
    }

    private String getDownloadUrl() throws ExecutionException, InterruptedException {
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            try {
                URL target = new URL(downloadLinkUrl);
                HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200 || responseCode == 204) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuffer resp = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        resp.append(inputLine);
                    }
                    in.close();
                    String response = resp.toString();
                    response = response.replaceAll("[\r\n\t]", "");
                    return response;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
        return future.get();
    }

    public String getLatestFilename() throws ExecutionException, InterruptedException {
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
            try {
                URL target = new URL(filenameUrl);
                HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200 || responseCode == 204) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuffer resp = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        resp.append(inputLine);
                    }
                    in.close();
                    String response = resp.toString();
                    response = response.replaceAll("[\r\n\t]", "");
                    return response;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        });
        return future.get();
    }

    public byte[] getLatestFile(String url) throws ExecutionException, InterruptedException {
        CompletableFuture<byte[]> future = CompletableFuture.supplyAsync(() -> {
            try {
                int nRead;
                URL fileUrl = new URL(url);
                URLConnection connection = fileUrl.openConnection();
                InputStream inputStream = connection.getInputStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                return buffer.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        });
        return future.get();
    }

    public int getLatestVersion() throws IOException {
        URL target = new URL(buildNumberUrl);
        HttpURLConnection connection = (HttpURLConnection)target.openConnection();
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200 || responseCode == 204) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer resp = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                resp.append(inputLine);
            }
            in.close();
            String response = resp.toString();
            response = response.replaceAll("[\r\n\t]", "");
            return Integer.parseInt(response);
        }
        return -1;
    }
}

