/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.version;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import net.achymake.homes.Homes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final Homes plugin;
    private final int resourceId;

    public UpdateChecker(Homes plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                Scanner scanner = new Scanner(inputStream);
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                    scanner.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                this.plugin.sendMessage("Unable to check for updates: " + e.getMessage());
            }
        });
    }

    public static void getUpdate(Homes plugin) {
        if (plugin.getConfig().getBoolean("notify-update.enable")) {
            new UpdateChecker(plugin, 107559).getVersion(latest -> {
                if (plugin.getDescription().getVersion().equalsIgnoreCase((String)latest)) {
                    plugin.sendMessage("You are using the latest version");
                } else {
                    plugin.sendMessage("&cNew update:&r " + latest);
                    plugin.sendMessage("&cCurrent version:&r " + plugin.getDescription().getVersion());
                }
            });
        }
    }

    public static void sendMessage(Player player) {
        if (Homes.instance.getConfig().getBoolean("notify-update.enable")) {
            new UpdateChecker(Homes.instance, 107559).getVersion(latest -> {
                if (!Homes.instance.getDescription().getVersion().equalsIgnoreCase((String)latest)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6" + Homes.instance.getName() + " Update:")));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6new release: &f" + latest)));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&6current: &f" + Homes.instance.getDescription().getVersion())));
                }
            });
        }
    }
}

