/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.config.PlayerConfig;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Settings {
    public static FileConfiguration getConfig(UUID uuid) {
        File file = new File(Homes.instance.getDataFolder(), "database/" + uuid + ".yml");
        if (!file.exists()) {
            PlayerConfig.create(uuid);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static boolean hasHomes(UUID uuid) {
        return Settings.getConfig(uuid).getKeys(false).contains("homes");
    }

    public static boolean homeExist(UUID uuid, String homeName) {
        return Settings.getConfig(uuid).getKeys(true).contains("homes." + homeName);
    }

    public static int getMaxHomes(UUID uuid) {
        return Settings.getConfig(uuid).getInt("max-homes");
    }

    public static int getHomeCount(UUID uuid) {
        if (Settings.getConfig(uuid).isConfigurationSection("homes")) {
            return Settings.getConfig(uuid).getConfigurationSection("homes").getKeys(false).size();
        }
        return 0;
    }

    public static List<String> getHomeNames(UUID uuid) {
        ArrayList<String> homes = new ArrayList<String>();
        if (Settings.hasHomes(uuid)) {
            for (String homeNames : Settings.getConfig(uuid).getConfigurationSection("homes").getKeys(false)) {
                homes.add(homeNames);
            }
        }
        return homes;
    }
}

