/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.config;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerConfig {
    public static void create(UUID uuid) {
        File folder = new File(Homes.instance.getDataFolder(), "database");
        File file = new File(Homes.instance.getDataFolder(), "database/" + uuid + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!file.exists()) {
            try {
                config.set("name", (Object)Bukkit.getOfflinePlayer((UUID)uuid).getName());
                config.set("max-homes", (Object)Config.get().getInt("settings.homes.default"));
                config.options().copyDefaults(true);
                config.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (config.getString("name") == null) {
            try {
                config.set("name", (Object)Bukkit.getOfflinePlayer((UUID)uuid).getName());
                config.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!config.getString("name").equals(Bukkit.getOfflinePlayer((UUID)uuid).getName())) {
            try {
                config.set("name", (Object)Bukkit.getOfflinePlayer((UUID)uuid).getName());
                config.save(file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reload() {
        for (OfflinePlayer offlinePlayer : Bukkit.getServer().getOfflinePlayers()) {
            File configFile = new File(Homes.instance.getDataFolder(), "database/" + offlinePlayer.getUniqueId() + ".yml");
            if (!configFile.exists()) continue;
            try {
                YamlConfiguration.loadConfiguration((File)configFile).load(configFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

