/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.command.sethome;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.config.MessageConfig;
import net.achymake.homes.settings.Settings;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SetHomeCommand
implements CommandExecutor,
TabCompleter {
    private static void setHomeLocation(Player player, String home) {
        Location location = player.getLocation();
        File file = new File(Homes.instance.getDataFolder(), "database/" + player.getUniqueId() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("homes." + home + ".world", (Object)location.getWorld().getName());
        config.set("homes." + home + ".x", (Object)location.getX());
        config.set("homes." + home + ".y", (Object)location.getY());
        config.set("homes." + home + ".z", (Object)location.getZ());
        config.set("homes." + home + ".yaw", (Object)Float.valueOf(location.getYaw()));
        config.set("homes." + home + ".pitch", (Object)Float.valueOf(location.getPitch()));
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("command-sethome"), home)));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (player.isOnGround()) {
                UUID uuid = player.getUniqueId();
                if (args.length == 0) {
                    if (Settings.hasHomes(uuid)) {
                        if (Settings.homeExist(uuid, "home")) {
                            SetHomeCommand.setHomeLocation(player, "home");
                        } else if (Settings.getMaxHomes(uuid) > Settings.getHomeCount(uuid)) {
                            SetHomeCommand.setHomeLocation(player, "home");
                        } else {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageConfig.get().getString("error-reach-limit")));
                        }
                    } else {
                        SetHomeCommand.setHomeLocation(player, "home");
                    }
                } else if (args.length == 1) {
                    String homeName = args[0];
                    if (homeName.equalsIgnoreCase("bed")) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageConfig.get().getString("error-sethome-bed")));
                    } else if (homeName.equalsIgnoreCase("buy")) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageConfig.get().getString("error-sethome-buy")));
                    } else if (Settings.hasHomes(uuid)) {
                        if (Settings.homeExist(uuid, homeName)) {
                            SetHomeCommand.setHomeLocation(player, homeName);
                        } else if (Settings.getMaxHomes(uuid) > Settings.getHomeCount(uuid)) {
                            SetHomeCommand.setHomeLocation(player, homeName);
                        } else {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageConfig.get().getString("error-reach-limit")));
                        }
                    } else {
                        SetHomeCommand.setHomeLocation(player, homeName);
                    }
                }
            } else {
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageConfig.get().getString("error-not-on-ground"))));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player player;
        UUID uuid;
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && Settings.hasHomes(uuid = (player = (Player)sender).getUniqueId())) {
            for (String home : Settings.getHomeNames(uuid)) {
                commands.add(home);
            }
            return commands;
        }
        return commands;
    }
}

