/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.command.homes.sub;

import java.io.File;
import java.text.MessageFormat;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.command.homes.HomesSubCommand;
import net.achymake.homes.config.MessageConfig;
import net.achymake.homes.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Teleport
extends HomesSubCommand {
    @Override
    public String getName() {
        return "teleport";
    }

    @Override
    public String getDescription() {
        return "teleports to players homes";
    }

    @Override
    public String getSyntax() {
        return "/homes teleport player home";
    }

    @Override
    public void perform(Player player, String[] args) {
        if (player.hasPermission("homes.teleport") && args.length == 3) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
            UUID uuid = offlinePlayer.getUniqueId();
            String homeName = args[2];
            if (Settings.hasHomes(uuid)) {
                if (Settings.homeExist(uuid, homeName)) {
                    Teleport.getHome(player, uuid, homeName);
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("error-target-home-null"), offlinePlayer.getName(), homeName)));
                }
            }
        }
    }

    public static void getHome(Player player, UUID uuidTarget, String home) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuidTarget);
        File file = new File(Homes.instance.getDataFolder(), "database/" + uuidTarget + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String world = config.getString("homes." + home + ".world");
        double x = config.getDouble("homes." + home + ".x");
        double y = config.getDouble("homes." + home + ".y");
        double z = config.getDouble("homes." + home + ".z");
        float yaw = config.getLong("homes." + home + ".yaw");
        float pitch = config.getLong("homes." + home + ".pitch");
        Location location = new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
        location.getChunk().load();
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("command-homes-teleport"), offlinePlayer.getName(), home)));
        player.teleport(location);
    }
}

