/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.command.homes.sub;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.command.homes.HomesSubCommand;
import net.achymake.homes.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Delete
extends HomesSubCommand {
    @Override
    public String getName() {
        return "delete";
    }

    @Override
    public String getDescription() {
        return "deletes others home";
    }

    @Override
    public String getSyntax() {
        return "/homes delete player home";
    }

    @Override
    public void perform(Player player, String[] args) {
        if (player.hasPermission("homes.delete") && args.length == 3) {
            String homeName;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[1]);
            UUID uuid = offlinePlayer.getUniqueId();
            if (Settings.homeExist(uuid, homeName = args[2])) {
                Delete.delHomeLocation(uuid, homeName);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format("&6Deleted &f{1}&6 of &f{0}", offlinePlayer.getName(), homeName)));
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format("&cHome &f{1}&6of &f{0}&c does not exist", offlinePlayer.getName(), homeName)));
            }
        }
    }

    private static void delHomeLocation(UUID uuid, String home) {
        File file = new File(Homes.instance.getDataFolder(), "database/" + uuid + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("homes." + home, null);
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

