/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.command.homes;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.command.homes.HomesSubCommand;
import net.achymake.homes.command.homes.sub.Delete;
import net.achymake.homes.command.homes.sub.Reload;
import net.achymake.homes.command.homes.sub.Teleport;
import net.achymake.homes.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class HomesCommand
implements CommandExecutor,
TabCompleter {
    public ArrayList<HomesSubCommand> homesSubCommands = new ArrayList();

    public HomesCommand() {
        this.homesSubCommands.add(new Delete());
        this.homesSubCommands.add(new Reload());
        this.homesSubCommands.add(new Teleport());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block7: {
            if (!(sender instanceof Player)) break block7;
            if (args.length == 0) {
                Player player = (Player)sender;
                UUID uuid = player.getUniqueId();
                if (Settings.getHomeCount(uuid) > 0) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6Homes:"));
                    if (player.hasPermission("homes.bed") && player.getBedSpawnLocation() != null) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7-&f bed"));
                    }
                    File file = new File(Homes.instance.getDataFolder(), "database/" + uuid + ".yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    for (String listedHomes : config.getConfigurationSection("homes").getKeys(false)) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7-&f " + listedHomes)));
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6You havent set any homes yet"));
                }
            } else {
                for (HomesSubCommand commands : this.homesSubCommands) {
                    if (!args[0].equals(commands.getName())) continue;
                    commands.perform((Player)sender, args);
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        UUID uuid;
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("homes.delete")) {
                commands.add("delete");
            }
            if (sender.hasPermission("homes.reload")) {
                commands.add("reload");
            }
            if (sender.hasPermission("homes.teleport")) {
                commands.add("teleport");
            }
            return commands;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("teleport")) {
                for (OfflinePlayer offlinePlayers : sender.getServer().getOfflinePlayers()) {
                    commands.add(Bukkit.getOfflinePlayer((UUID)offlinePlayers.getUniqueId()).getName());
                }
                return commands;
            }
            if (args[0].equalsIgnoreCase("delete")) {
                for (OfflinePlayer offlinePlayers : sender.getServer().getOfflinePlayers()) {
                    commands.add(Bukkit.getOfflinePlayer((UUID)offlinePlayers.getUniqueId()).getName());
                }
                return commands;
            }
        } else if (args.length == 3 && sender.hasPermission("homes.teleport") && Settings.hasHomes(uuid = Bukkit.getOfflinePlayer((String)args[1]).getUniqueId())) {
            for (String home : Settings.getHomeNames(uuid)) {
                commands.add(home);
            }
        }
        return commands;
    }
}

