/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.command.home;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.config.Config;
import net.achymake.homes.config.MessageConfig;
import net.achymake.homes.settings.Settings;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            if (args.length == 0) {
                Player player = (Player)sender;
                UUID uuid = player.getUniqueId();
                String homeName = "home";
                if (Settings.hasHomes(uuid)) {
                    if (Settings.homeExist(uuid, homeName)) {
                        HomeCommand.getHome(player, homeName);
                    } else {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("error-home-does-not-exist"), homeName)));
                    }
                }
            } else if (args.length == 1) {
                Player player = (Player)sender;
                UUID uuid = player.getUniqueId();
                String homeName = args[0];
                if (homeName.equalsIgnoreCase("buy")) {
                    if (player.hasPermission("homes.buy")) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("command-home-cost"), Homes.econ.format(Config.get().getDouble("settings.homes.cost")))));
                    }
                } else if (homeName.equalsIgnoreCase("bed")) {
                    if (player.getBedSpawnLocation() != null) {
                        if (player.hasPermission("homes.bed")) {
                            Location location = player.getBedSpawnLocation();
                            location.setPitch(player.getLocation().getPitch());
                            location.setYaw(player.getLocation().getYaw());
                            player.getBedSpawnLocation().getChunk().load();
                            player.teleport(location);
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("command-home"), homeName)));
                        }
                    } else {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("error-home-does-not-exist"), homeName)));
                    }
                } else if (Settings.homeExist(uuid, homeName)) {
                    HomeCommand.getHome(player, homeName);
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("error-home-does-not-exist"), homeName)));
                }
            } else if (args.length == 2) {
                Player player = (Player)sender;
                UUID uuid = player.getUniqueId();
                String homeName = args[0];
                if (homeName.equalsIgnoreCase("buy") && player.hasPermission("homes.buy")) {
                    if (Homes.econ.getBalance((OfflinePlayer)player) > Config.get().getDouble("settings.homes.cost") * Double.parseDouble(args[1])) {
                        HomeCommand.buyHome(player, Integer.parseInt(args[1]));
                        Homes.econ.withdrawPlayer((OfflinePlayer)player, Config.get().getDouble("settings.homes.cost") * Double.parseDouble(args[1]));
                        for (String messages : MessageConfig.get().getStringList("command-home-buy")) {
                            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(messages, args[1], Homes.econ.format(Config.get().getDouble("settings.homes.cost") * Double.parseDouble(args[1])), Settings.getMaxHomes(uuid))));
                        }
                    } else {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("error-not-enough-currency"), Homes.econ.format(Config.get().getDouble("settings.homes.cost") * Double.parseDouble(args[1])))));
                    }
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        Player player = (Player)sender;
        if (args.length == 1) {
            UUID uuid = player.getUniqueId();
            if (Settings.hasHomes(uuid)) {
                for (String home : Settings.getHomeNames(uuid)) {
                    commands.add(home);
                }
            }
            if (player.hasPermission("homes.bed") && player.getBedSpawnLocation() != null) {
                commands.add("bed");
            }
            if (player.hasPermission("homes.buy")) {
                commands.add("buy");
            }
            return commands;
        }
        if (args.length == 2 && player.hasPermission("homes.buy") && args[0].equalsIgnoreCase("buy")) {
            commands.add("1");
            commands.add("2");
            commands.add("3");
            return commands;
        }
        return commands;
    }

    private static void buyHome(Player player, int amount) {
        File file = new File(Homes.instance.getDataFolder(), "database/" + player.getUniqueId() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        int addAmount = config.getInt("max-homes") + amount;
        config.set("max-homes", (Object)addAmount);
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void getHome(Player player, String home) {
        File file = new File(Homes.instance.getDataFolder(), "database/" + player.getUniqueId() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String world = config.getString("homes." + home + ".world");
        double x = config.getDouble("homes." + home + ".x");
        double y = config.getDouble("homes." + home + ".y");
        double z = config.getDouble("homes." + home + ".z");
        float yaw = config.getLong("homes." + home + ".yaw");
        float pitch = config.getLong("homes." + home + ".pitch");
        Location location = new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
        location.getChunk().load();
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("command-home"), home)));
        player.teleport(location);
    }
}

