/*
 * Decompiled with CFR 0.152.
 */
package net.achymake.homes.command.delhome;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.achymake.homes.Homes;
import net.achymake.homes.config.MessageConfig;
import net.achymake.homes.settings.Settings;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class DelHomeCommand
implements CommandExecutor,
TabCompleter {
    private static void delHomeLocation(Player player, String home) {
        File file = new File(Homes.instance.getDataFolder(), "database/" + player.getUniqueId() + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        config.set("homes." + home, null);
        try {
            config.save(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("command-delhome"), home)));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player && args.length == 1) {
            String homeName;
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            if (Settings.homeExist(uuid, homeName = args[0])) {
                DelHomeCommand.delHomeLocation(player, homeName);
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)MessageFormat.format(MessageConfig.get().getString("error-home-does-not-exist"), homeName)));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player player;
        UUID uuid;
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1 && Settings.hasHomes(uuid = (player = (Player)sender).getUniqueId())) {
            for (String home : Settings.getHomeNames(uuid)) {
                commands.add(home);
            }
            return commands;
        }
        return commands;
    }
}

