/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.objects;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.Placeholder;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final CleanSS instance = CleanSS.getInstance();
    private static ScheduledTask titleTask;

    public static List<String> getStringList(@NotNull VelocityMessages velocityMessages) {
        return instance.getMessagesTextFile().getConfig().getStringList(velocityMessages.getPath());
    }

    public static List<String> getStringList(VelocityMessages velocityMessages, Placeholder ... placeholders) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : Utils.getStringList(velocityMessages)) {
            s = Utils.applyPlaceHolder(s, placeholders);
            newList.add(s);
        }
        return newList;
    }

    public static String applyPlaceHolder(String s, Placeholder ... placeholders) {
        for (Placeholder placeholder : placeholders) {
            s = s.replace(placeholder.getKey(), placeholder.getValue());
        }
        return s;
    }

    public static String color(@NotNull String s) {
        return s.replace("&", "\u00a7");
    }

    public static List<String> color(@NotNull List<String> list) {
        return list.stream().map(Utils::color).collect(Collectors.toList());
    }

    public static void sendList(CommandSource commandSource, @NotNull List<String> stringList, Player player_name) {
        for (String message : stringList) {
            if (message.contains(VelocityMessages.CONTROL_CLEAN_NAME.get(String.class))) {
                commandSource.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)VelocityMessages.CONTROL_CLEAN_COMMAND.get(String.class).replace("%player%", player_name.getUsername()))));
                continue;
            }
            if (message.contains(VelocityMessages.CONTROL_CHEATER_NAME.get(String.class))) {
                commandSource.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)VelocityMessages.CONTROL_CHEATER_COMMAND.get(String.class).replace("%player%", player_name.getUsername()))));
                continue;
            }
            if (message.contains(VelocityMessages.CONTROL_ADMIT_NAME.get(String.class))) {
                commandSource.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)VelocityMessages.CONTROL_ADMIT_COMMAND.get(String.class).replace("%player%", player_name.getUsername()))));
                continue;
            }
            if (message.contains(VelocityMessages.CONTROL_REFUSE_NAME.get(String.class))) {
                commandSource.sendMessage(LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.SUGGEST_COMMAND, (String)VelocityMessages.CONTROL_REFUSE_COMMAND.get(String.class).replace("%player%", player_name.getUsername()))));
                continue;
            }
            commandSource.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(message));
        }
    }

    public static void sendFormattedList(VelocityMessages velocityMessages, CommandSource commandSource, Player player_name, Placeholder ... placeholders) {
        Utils.sendList(commandSource, Utils.color(Utils.getStringList(velocityMessages, placeholders)), player_name);
    }

    public static void finishControl(@NotNull Player suspicious, @NotNull Player administrator, RegisteredServer proxyServer) {
        if (suspicious.isActive() && administrator.isActive()) {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getCouples().remove(administrator, suspicious);
            if (!suspicious.getCurrentServer().isPresent()) {
                return;
            }
            if (((ServerConnection)suspicious.getCurrentServer().get()).getServer().getServerInfo().getName().equals(VelocityConfig.CONTROL.get(String.class))) {
                suspicious.createConnectionRequest(proxyServer).fireAndForget();
                Utils.sendEndTitle(suspicious);
                suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.FINISHSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                if (!administrator.getCurrentServer().isPresent()) {
                    return;
                }
                if (((ServerConnection)administrator.getCurrentServer().get()).getServer().getServerInfo().getName().equals(VelocityConfig.CONTROL.get(String.class))) {
                    administrator.createConnectionRequest(proxyServer).fireAndForget();
                }
            }
        } else if (suspicious.isActive()) {
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            suspicious.createConnectionRequest(proxyServer).fireAndForget();
            Utils.sendEndTitle(suspicious);
            suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.FINISHSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            PlayerCache.getCouples().remove(administrator);
        } else if (administrator.isActive()) {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            administrator.createConnectionRequest(proxyServer).fireAndForget();
            administrator.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.LEAVESUS.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", suspicious.getUsername())));
            PlayerCache.getCouples().remove(administrator);
        } else {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getCouples().remove(administrator);
        }
    }

    public static void startControl(@NotNull Player suspicious, @NotNull Player administrator, RegisteredServer proxyServer) {
        PlayerCache.getAdministrator().add(administrator.getUniqueId());
        PlayerCache.getSuspicious().add(suspicious.getUniqueId());
        PlayerCache.getCouples().put(administrator, suspicious);
        if (!administrator.getCurrentServer().isPresent()) {
            return;
        }
        if (!suspicious.getCurrentServer().isPresent()) {
            return;
        }
        if (((ServerConnection)administrator.getCurrentServer().get()).getServer() != proxyServer) {
            administrator.createConnectionRequest(proxyServer).fireAndForget();
        } else {
            Utils.sendChannelMessage(administrator, "ADMIN");
            if (administrator.getProtocolVersion().getProtocol() >= ProtocolVersion.getProtocolVersion((int)759).getProtocol()) {
                Utils.sendChannelMessage(administrator, "NO_CHAT");
            }
        }
        if (((ServerConnection)suspicious.getCurrentServer().get()).getServer() != proxyServer) {
            suspicious.createConnectionRequest(proxyServer).fireAndForget();
        } else {
            Utils.sendChannelMessage(suspicious, "SUSPECT");
            if (suspicious.getProtocolVersion().getProtocol() >= ProtocolVersion.getProtocolVersion((int)759).getProtocol()) {
                Utils.sendChannelMessage(suspicious, "NO_CHAT");
            }
        }
        Utils.sendStartTitle(suspicious);
        if (VelocityConfig.CHECK_FOR_PROBLEMS.get(Boolean.class).booleanValue()) {
            Utils.checkForErrors(suspicious, administrator, proxyServer);
        }
        suspicious.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.MAINSUS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
        VelocityMessages.CONTROL_FORMAT.sendList((CommandSource)administrator, suspicious, new Placeholder("cleanname", VelocityMessages.CONTROL_CLEAN_NAME.color()), new Placeholder("hackername", VelocityMessages.CONTROL_CHEATER_NAME.color()), new Placeholder("admitname", VelocityMessages.CONTROL_ADMIT_NAME.color()), new Placeholder("refusename", VelocityMessages.CONTROL_REFUSE_NAME.color()));
    }

    public static void sendChannelMessage(@NotNull Player player, String type) {
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        buf.writeUTF(type);
        buf.writeUTF(player.getUsername());
        player.getCurrentServer().ifPresent(sv -> sv.sendPluginMessage(CleanSS.channel_join, buf.toByteArray()));
    }

    private static void checkForErrors(@NotNull Player suspicious, @NotNull Player administrator, RegisteredServer proxyServer) {
        instance.getServer().getScheduler().buildTask((Object)instance, () -> {
            if (!PlayerCache.getSuspicious().contains(suspicious.getUniqueId()) || !PlayerCache.getAdministrator().contains(administrator.getUniqueId())) {
                return;
            }
            if (!suspicious.getCurrentServer().isPresent() && !administrator.getCurrentServer().isPresent()) {
                return;
            }
            if (((ServerConnection)suspicious.getCurrentServer().get()).getServer().equals(proxyServer) && ((ServerConnection)administrator.getCurrentServer().get()).getServer().equals(proxyServer)) {
                return;
            }
            Optional fallbackServer = instance.getServer().getServer(VelocityConfig.CONTROL_FALLBACK.get(String.class));
            if (!fallbackServer.isPresent()) {
                return;
            }
            Utils.finishControl(suspicious, administrator, (RegisteredServer)fallbackServer.get());
            administrator.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_EXIST.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            instance.getLogger().error("Your control server is not configured correctly or is crashed, please check the configuration file. The Control cannot be handled!");
        }).delay(2L, TimeUnit.SECONDS).schedule();
    }

    public static boolean isConsole(CommandSource invocation) {
        return !(invocation instanceof Player);
    }

    private static void sendStartTitle(Player suspicious) {
        if (VelocityMessages.CONTROL_USETITLE.get(Boolean.class).booleanValue()) {
            Title controlTitle = Title.title((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_TITLE.color()), (Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROL_SUBTITLE.color()), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(VelocityMessages.CONTROL_FADEIN.get(Integer.class).intValue()), (Duration)Duration.ofSeconds(VelocityMessages.CONTROL_STAY.get(Integer.class).intValue()), (Duration)Duration.ofSeconds(VelocityMessages.CONTROL_FADEOUT.get(Integer.class).intValue())));
            titleTask = instance.getServer().getScheduler().buildTask((Object)instance, () -> suspicious.showTitle(controlTitle)).delay((long)VelocityMessages.CONTROL_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule();
        }
    }

    private static void sendEndTitle(Player suspicious) {
        if (VelocityMessages.CONTROLFINISH_USETITLE.get(Boolean.class).booleanValue()) {
            Title controlTitle = Title.title((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROLFINISH_TITLE.color()), (Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.CONTROLFINISH_SUBTITLE.color()), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(VelocityMessages.CONTROLFINISH_FADEIN.get(Integer.class).intValue()), (Duration)Duration.ofSeconds(VelocityMessages.CONTROLFINISH_STAY.get(Integer.class).intValue()), (Duration)Duration.ofSeconds(VelocityMessages.CONTROLFINISH_FADEOUT.get(Integer.class).intValue())));
            titleTask = instance.getServer().getScheduler().buildTask((Object)instance, () -> suspicious.showTitle(controlTitle)).delay((long)VelocityMessages.CONTROLFINISH_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS).schedule();
        }
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static ScheduledTask getTitleTask() {
        return titleTask;
    }
}

