/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class KickListener {
    public CleanSS instance;

    public KickListener(CleanSS instance) {
        this.instance = instance;
    }

    @Subscribe
    public void onPlayerConnect(@NotNull ServerPreConnectEvent event) {
        Player player = event.getPlayer();
        RegisteredServer server = event.getOriginalServer();
        if (server == null) {
            if (player.hasPermission(VelocityConfig.RELOAD_PERMISSION.get(String.class))) {
                this.instance.UpdateChecker(player);
            }
            return;
        }
        if (!server.getServerInfo().getName().equals(VelocityConfig.CONTROL.get(String.class)) && (PlayerCache.getSuspicious().contains(player.getUniqueId()) || PlayerCache.getAdministrator().contains(player.getUniqueId()))) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
        }
    }

    @Subscribe
    public void onPlayerDisconnect(@NotNull DisconnectEvent event) {
        Optional proxyServer = this.instance.getServer().getServer(VelocityConfig.CONTROL_FALLBACK.get(String.class));
        Player player = event.getPlayer();
        if (!proxyServer.isPresent()) {
            return;
        }
        if (PlayerCache.getAdministrator().contains(player.getUniqueId())) {
            Utils.finishControl(this.instance.getValue(PlayerCache.getCouples(), player), player, (RegisteredServer)proxyServer.get());
        } else if (PlayerCache.getSuspicious().contains(player.getUniqueId())) {
            Utils.finishControl(player, this.instance.getKey(PlayerCache.getCouples(), player), (RegisteredServer)proxyServer.get());
        }
    }
}

