/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import it.frafol.cleanss.velocity.CleanSS;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.objects.PlayerCache;
import it.frafol.cleanss.velocity.objects.Utils;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class ControlCommand
implements SimpleCommand {
    public final CleanSS instance;

    public ControlCommand(CleanSS instance) {
        this.instance = instance;
    }

    public void execute(@NotNull SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        if (Utils.isConsole(source)) {
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.ONLY_PLAYERS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length == 0) {
            if (!source.hasPermission(VelocityConfig.CONTROL_PERMISSION.get(String.class))) {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_PERMISSION.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                return;
            }
            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.USAGE.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
            return;
        }
        if (((String[])invocation.arguments()).length == 1) {
            if (this.instance.getServer().getAllPlayers().toString().contains(((String[])invocation.arguments())[0])) {
                Optional player = this.instance.getServer().getPlayer(((String[])invocation.arguments())[0]);
                Player sender = (Player)source;
                if (!player.isPresent()) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
                    return;
                }
                if (((Player)player.get()).hasPermission(VelocityConfig.BYPASS_PERMISSION.get(String.class))) {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.PLAYER_BYPASS.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                    return;
                }
                if (this.instance.getServer().getAllServers().toString().contains(VelocityConfig.CONTROL.get(String.class))) {
                    Optional proxyServer = this.instance.getServer().getServer(VelocityConfig.CONTROL.get(String.class));
                    if (!proxyServer.isPresent()) {
                        return;
                    }
                    if (sender.getUniqueId() == ((Player)player.get()).getUniqueId()) {
                        source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.YOURSELF.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                        return;
                    }
                    if (PlayerCache.getSuspicious().contains(((Player)player.get()).getUniqueId())) {
                        return;
                    }
                    ((RegisteredServer)proxyServer.get()).ping().whenComplete((result, throwable) -> {
                        if (throwable != null) {
                            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_EXIST.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                            return;
                        }
                        if (result == null) {
                            source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_EXIST.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                            return;
                        }
                        Utils.startControl((Player)player.get(), sender, (RegisteredServer)proxyServer.get());
                    });
                } else {
                    source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NO_EXIST.color().replace("%prefix%", VelocityMessages.PREFIX.color())));
                }
            } else {
                source.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize(VelocityMessages.NOT_ONLINE.color().replace("%prefix%", VelocityMessages.PREFIX.color()).replace("%player%", ((String[])invocation.arguments())[0])));
            }
        }
    }
}

