/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import it.frafol.cleanss.velocity.Metrics;
import it.frafol.cleanss.velocity.UpdateCheck;
import it.frafol.cleanss.velocity.commands.ControlCommand;
import it.frafol.cleanss.velocity.commands.FinishCommand;
import it.frafol.cleanss.velocity.commands.ReloadCommand;
import it.frafol.cleanss.velocity.enums.VelocityConfig;
import it.frafol.cleanss.velocity.enums.VelocityMessages;
import it.frafol.cleanss.velocity.listeners.ChatListener;
import it.frafol.cleanss.velocity.listeners.CommandListener;
import it.frafol.cleanss.velocity.listeners.KickListener;
import it.frafol.cleanss.velocity.listeners.ServerListener;
import it.frafol.cleanss.velocity.objects.TextFile;
import java.nio.file.Path;
import java.util.Map;
import net.byteflux.libby.Library;
import net.byteflux.libby.VelocityLibraryManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Plugin(id="cleanscreenshare", name="CleanScreenShare", version="1.1.3", description="Make control hacks on your players.", authors={"frafol"})
public class CleanSS {
    public static final ChannelIdentifier channel_join = MinecraftChannelIdentifier.create((String)"cleanss", (String)"join");
    private final Logger logger;
    private final ProxyServer server;
    private final Path path;
    private final Metrics.Factory metricsFactory;
    private TextFile messagesTextFile;
    private TextFile configTextFile;
    private static CleanSS instance;
    @Inject
    public PluginContainer container;

    public static CleanSS getInstance() {
        return instance;
    }

    @Inject
    public CleanSS(Logger logger, ProxyServer server, @DataDirectory Path path, Metrics.Factory metricsFactory) {
        this.server = server;
        this.logger = logger;
        this.path = path;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        this.loadLibraries();
        this.logger.info("\n\u00a7d   ___  __    ____    __    _  _   ___  ___\n  / __)(  )  ( ___)  /__\\  ( \\( ) / __)/ __)\n ( (__  )(__  )__)  /(__)\\  )  (  \\__ \\\\__ \\\n  \\___)(____)(____)(__)(__)(_)\\_) (___/(___/\n");
        this.logger.info("\u00a77Loading \u00a7dconfiguration\u00a77...");
        this.loadFiles();
        this.logger.info("\u00a77Loading \u00a7dplugin\u00a77...");
        this.loadChannelRegistrar();
        this.loadListeners();
        this.loadCommands();
        if (VelocityConfig.STATS.get(Boolean.class).booleanValue()) {
            this.metricsFactory.make(this, 16951);
            this.logger.info("\u00a77Metrics loaded \u00a7dsuccessfully\u00a77!");
        }
        if (!this.getUnsignedVelocityAddon()) {
            this.getLogger().warn("To get the full functionality of CleanScreenShare for versions 1.19.1 and later on Velocity, consider downloading https://github.com/4drian3d/UnSignedVelocity/releases/latest");
        }
        this.UpdateChecker();
        this.logger.info("\u00a77Plugin \u00a7dsuccessfully \u00a77loaded!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info("\u00a77Clearing \u00a7dinstances\u00a77...");
        instance = null;
        this.logger.info("\u00a77Plugin successfully \u00a7ddisabled\u00a77!");
    }

    private void loadLibraries() {
        VelocityLibraryManager<CleanSS> velocityLibraryManager = new VelocityLibraryManager<CleanSS>(this.getLogger(), this.path, this.getServer().getPluginManager(), this);
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").build();
        velocityLibraryManager.addJitPack();
        velocityLibraryManager.loadLibrary(yaml);
    }

    private void loadFiles() {
        this.configTextFile = new TextFile(this.path, "config.yml");
        this.messagesTextFile = new TextFile(this.path, "messages.yml");
    }

    private void loadCommands() {
        CleanSS.getInstance().getServer().getCommandManager().register(this.server.getCommandManager().metaBuilder("ss").aliases(new String[]{"cleanss", "control"}).build(), (Command)new ControlCommand(this));
        CleanSS.getInstance().getServer().getCommandManager().register(this.server.getCommandManager().metaBuilder("ssfinish").aliases(new String[]{"cleanssfinish", "controlfinish"}).build(), (Command)new FinishCommand(this));
        CleanSS.getInstance().getServer().getCommandManager().register(this.server.getCommandManager().metaBuilder("ssreload").aliases(new String[]{"cleanssreload", "controlreload"}).build(), (Command)new ReloadCommand(this));
    }

    private void loadChannelRegistrar() {
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{channel_join});
    }

    private void loadListeners() {
        this.server.getEventManager().register((Object)this, (Object)new ServerListener(this));
        this.server.getEventManager().register((Object)this, (Object)new CommandListener(this));
        if (VelocityMessages.CONTROL_CHAT.get(Boolean.class).booleanValue()) {
            this.server.getEventManager().register((Object)this, (Object)new ChatListener(this));
        }
        this.server.getEventManager().register((Object)this, (Object)new KickListener(this));
    }

    private void UpdateChecker() {
        if (!VelocityConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        if (!this.container.getDescription().getVersion().isPresent()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                this.logger.warn("There is a new update available, download it on SpigotMC!");
            }
            if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                this.logger.warn("You are using a development version, please report any bugs!");
            }
        });
    }

    public void UpdateChecker(Player player) {
        if (!VelocityConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        if (!this.container.getDescription().getVersion().isPresent()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(((String)this.container.getDescription().getVersion().get()).replace(".", "")) >= Integer.parseInt(version.replace(".", ""))) {
                return;
            }
            player.sendMessage((Component)LegacyComponentSerializer.legacy((char)'\u00a7').deserialize("\u00a7e[CleanScreenShare] There is a new update available, download it on SpigotMC!"));
        });
    }

    public <K, V> K getKey(@NotNull Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public <K, V> V getValue(@NotNull Map<K, V> map, K key) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public boolean getUnsignedVelocityAddon() {
        return this.getServer().getPluginManager().isLoaded("unsignedvelocity");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public Path getPath() {
        return this.path;
    }

    public Metrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    public TextFile getMessagesTextFile() {
        return this.messagesTextFile;
    }

    public TextFile getConfigTextFile() {
        return this.configTextFile;
    }

    public PluginContainer getContainer() {
        return this.container;
    }
}

