/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.objects;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.objects.Placeholder;
import it.frafol.cleanss.bungee.objects.PlayerCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final CleanSS instance = CleanSS.getInstance();

    public static List<String> getStringList(@NotNull BungeeMessages velocityMessages) {
        return instance.getMessagesTextFile().getStringList(velocityMessages.getPath());
    }

    public static List<String> getStringList(BungeeMessages velocityMessages, Placeholder ... placeholders) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : Utils.getStringList(velocityMessages)) {
            s = Utils.applyPlaceHolder(s, placeholders);
            newList.add(s);
        }
        return newList;
    }

    public static String applyPlaceHolder(String s, Placeholder ... placeholders) {
        for (Placeholder placeholder : placeholders) {
            s = s.replace(placeholder.getKey(), placeholder.getValue());
        }
        return s;
    }

    public static String color(@NotNull String s) {
        return s.replace("&", "\u00a7");
    }

    public static List<String> color(@NotNull List<String> list) {
        return list.stream().map(Utils::color).collect(Collectors.toList());
    }

    public static void sendList(CommandSender commandSource, @NotNull List<String> stringList, ProxiedPlayer player_name) {
        for (String message : stringList) {
            TextComponent suggestMessage = new TextComponent(message);
            if (message.contains(BungeeMessages.CONTROL_CLEAN_NAME.get(String.class))) {
                suggestMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, BungeeMessages.CONTROL_CLEAN_COMMAND.get(String.class).replace("%player%", player_name.getName())));
                commandSource.sendMessage((BaseComponent)suggestMessage);
                continue;
            }
            if (message.contains(BungeeMessages.CONTROL_CHEATER_NAME.get(String.class))) {
                suggestMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, BungeeMessages.CONTROL_CHEATER_COMMAND.get(String.class).replace("%player%", player_name.getName())));
                commandSource.sendMessage((BaseComponent)suggestMessage);
                continue;
            }
            if (message.contains(BungeeMessages.CONTROL_ADMIT_NAME.get(String.class))) {
                suggestMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, BungeeMessages.CONTROL_ADMIT_COMMAND.get(String.class).replace("%player%", player_name.getName())));
                commandSource.sendMessage((BaseComponent)suggestMessage);
                continue;
            }
            if (message.contains(BungeeMessages.CONTROL_REFUSE_NAME.get(String.class))) {
                suggestMessage.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, BungeeMessages.CONTROL_REFUSE_COMMAND.get(String.class).replace("%player%", player_name.getName())));
                commandSource.sendMessage((BaseComponent)suggestMessage);
                continue;
            }
            commandSource.sendMessage(TextComponent.fromLegacyText((String)message));
        }
    }

    public static void sendFormattedList(BungeeMessages velocityMessages, CommandSender commandSender, ProxiedPlayer player_name, Placeholder ... placeholders) {
        Utils.sendList(commandSender, Utils.color(Utils.getStringList(velocityMessages, placeholders)), player_name);
    }

    public static void finishControl(@NotNull ProxiedPlayer suspicious, @NotNull ProxiedPlayer administrator, ServerInfo proxyServer) {
        if (administrator.isConnected() && suspicious.isConnected()) {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getCouples().remove(administrator, suspicious);
            if (administrator.getServer() == null) {
                return;
            }
            if (administrator.getServer().getInfo().getName().equals(BungeeConfig.CONTROL.get(String.class))) {
                if (proxyServer == null) {
                    return;
                }
                administrator.connect(proxyServer);
                Utils.sendEndTitle(suspicious);
                administrator.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.FINISHSUS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                if (suspicious.getServer() == null) {
                    return;
                }
                if (suspicious.getServer().getInfo().getName().equals(BungeeConfig.CONTROL.get(String.class))) {
                    suspicious.connect(proxyServer);
                }
            }
        } else if (suspicious.isConnected()) {
            if (instance.getValue(PlayerCache.getCouples(), administrator) == null) {
                return;
            }
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            suspicious.connect(proxyServer);
            Utils.sendEndTitle(suspicious);
            suspicious.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.FINISHSUS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            PlayerCache.getCouples().remove(administrator);
        } else if (administrator.isConnected()) {
            PlayerCache.getAdministrator().remove(administrator.getUniqueId());
            PlayerCache.getSuspicious().remove(suspicious.getUniqueId());
            administrator.connect(proxyServer);
            administrator.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.LEAVESUS.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%player%", suspicious.getName())));
            PlayerCache.getCouples().remove(administrator);
        }
    }

    public static void startControl(@NotNull ProxiedPlayer suspicious, @NotNull ProxiedPlayer administrator, ServerInfo proxyServer) {
        PlayerCache.getAdministrator().add(administrator.getUniqueId());
        PlayerCache.getSuspicious().add(suspicious.getUniqueId());
        PlayerCache.getCouples().put(administrator, suspicious);
        if (!Objects.equals(administrator.getServer().getInfo(), proxyServer)) {
            administrator.connect(proxyServer);
        } else {
            Utils.sendChannelMessage(administrator, "ADMIN");
        }
        if (!Objects.equals(suspicious.getServer().getInfo(), proxyServer)) {
            suspicious.connect(proxyServer);
        } else {
            Utils.sendChannelMessage(suspicious, "SUSPECT");
        }
        Utils.sendStartTitle(suspicious);
        if (BungeeConfig.CHECK_FOR_PROBLEMS.get(Boolean.class).booleanValue()) {
            Utils.checkForErrors(suspicious, administrator, proxyServer);
        }
        suspicious.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.MAINSUS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
        BungeeMessages.CONTROL_FORMAT.sendList((CommandSender)administrator, suspicious, new Placeholder("cleanname", BungeeMessages.CONTROL_CLEAN_NAME.color()), new Placeholder("hackername", BungeeMessages.CONTROL_CHEATER_NAME.color()), new Placeholder("admitname", BungeeMessages.CONTROL_ADMIT_NAME.color()), new Placeholder("refusename", BungeeMessages.CONTROL_REFUSE_NAME.color()));
    }

    private static void checkForErrors(ProxiedPlayer suspicious, ProxiedPlayer administrator, ServerInfo proxyServer) {
        instance.getProxy().getScheduler().schedule((Plugin)instance, () -> {
            if (!PlayerCache.getSuspicious().contains(suspicious.getUniqueId()) || !PlayerCache.getAdministrator().contains(administrator.getUniqueId())) {
                return;
            }
            if (suspicious.getServer().getInfo().equals(proxyServer) && administrator.getServer().getInfo().equals(proxyServer)) {
                return;
            }
            ServerInfo fallbackServer = instance.getProxy().getServerInfo(BungeeConfig.CONTROL_FALLBACK.get(String.class));
            Utils.finishControl(suspicious, administrator, fallbackServer);
            administrator.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NO_EXIST.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            instance.getLogger().severe("Your control server is not configured correctly or is crashed, please check the configuration file. The Control cannot be handled!");
        }, 2L, TimeUnit.SECONDS);
    }

    public static void sendChannelMessage(@NotNull ProxiedPlayer player, String type) {
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        buf.writeUTF(type);
        buf.writeUTF(player.getName());
        player.getServer().sendData("cleanss:join", buf.toByteArray());
    }

    private static void sendStartTitle(ProxiedPlayer suspicious) {
        if (!BungeeMessages.CONTROL_USETITLE.get(Boolean.class).booleanValue()) {
            return;
        }
        Title title = ProxyServer.getInstance().createTitle();
        title.fadeIn(BungeeMessages.CONTROL_FADEIN.get(Integer.class) * 20);
        title.stay(BungeeMessages.CONTROL_STAY.get(Integer.class) * 20);
        title.fadeOut(BungeeMessages.CONTROL_FADEOUT.get(Integer.class) * 20);
        title.title((BaseComponent)new TextComponent(BungeeMessages.CONTROL_TITLE.color()));
        title.subTitle((BaseComponent)new TextComponent(BungeeMessages.CONTROL_SUBTITLE.color()));
        ProxyServer.getInstance().getScheduler().schedule((Plugin)instance, () -> title.send(suspicious), (long)BungeeMessages.CONTROL_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS);
    }

    private static void sendEndTitle(ProxiedPlayer suspicious) {
        if (!BungeeMessages.CONTROLFINISH_USETITLE.get(Boolean.class).booleanValue()) {
            return;
        }
        Title title = ProxyServer.getInstance().createTitle();
        title.fadeIn(BungeeMessages.CONTROLFINISH_FADEIN.get(Integer.class) * 20);
        title.stay(BungeeMessages.CONTROLFINISH_STAY.get(Integer.class) * 20);
        title.fadeOut(BungeeMessages.CONTROLFINISH_FADEOUT.get(Integer.class) * 20);
        title.title((BaseComponent)new TextComponent(BungeeMessages.CONTROLFINISH_TITLE.color()));
        title.subTitle((BaseComponent)new TextComponent(BungeeMessages.CONTROLFINISH_SUBTITLE.color()));
        ProxyServer.getInstance().getScheduler().schedule((Plugin)instance, () -> title.send(suspicious), (long)BungeeMessages.CONTROLFINISH_DELAY.get(Integer.class).intValue(), TimeUnit.SECONDS);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

