/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee.commands;

import it.frafol.cleanss.bungee.CleanSS;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.objects.PlayerCache;
import it.frafol.cleanss.bungee.objects.Utils;
import java.util.Optional;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import org.jetbrains.annotations.NotNull;

public class ControlCommand
extends Command {
    public final CleanSS instance;

    public ControlCommand(CleanSS instance) {
        super("ss", "", new String[]{"screenshare", "cleanss", "cleanscreenshare", "control"});
        this.instance = instance;
    }

    public void execute(@NotNull CommandSender invocation, String[] args) {
        if (!(invocation instanceof ProxiedPlayer)) {
            invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.ONLY_PLAYERS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            return;
        }
        if (args.length == 0) {
            if (!invocation.hasPermission(BungeeConfig.CONTROL_PERMISSION.get(String.class))) {
                invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NO_PERMISSION.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                return;
            }
            invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.USAGE.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
            return;
        }
        if (args.length == 1) {
            if (ProxyServer.getInstance().getPlayers().toString().contains(args[0])) {
                Optional<ProxiedPlayer> player = Optional.ofNullable(ProxyServer.getInstance().getPlayer(args[0]));
                ProxiedPlayer sender = (ProxiedPlayer)invocation;
                if (!player.isPresent()) {
                    invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NOT_ONLINE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%player%", args[0]).replace("&", "\u00a7")));
                    return;
                }
                if (player.get().hasPermission(BungeeConfig.BYPASS_PERMISSION.get(String.class))) {
                    invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.PLAYER_BYPASS.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                    return;
                }
                if (this.instance.getProxy().getServers().containsKey(BungeeConfig.CONTROL.get(String.class))) {
                    ServerInfo proxyServer = (ServerInfo)this.instance.getProxy().getServers().get(BungeeConfig.CONTROL.get(String.class));
                    if (proxyServer == null) {
                        return;
                    }
                    if (sender.getUniqueId() == player.get().getUniqueId()) {
                        invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.YOURSELF.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                        return;
                    }
                    if (PlayerCache.getSuspicious().contains(player.get().getUniqueId())) {
                        ProxyServer.getInstance().getLogger().severe("Player already in control");
                        return;
                    }
                    ((ServerInfo)this.instance.getProxy().getServers().get(proxyServer.getName())).ping((result, throwable) -> {
                        if (throwable != null) {
                            invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NO_EXIST.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                            return;
                        }
                        if (result == null) {
                            invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NO_EXIST.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                            return;
                        }
                        if (sender.getServer() == null) {
                            return;
                        }
                        if (((ProxiedPlayer)player.get()).getServer() == null) {
                            return;
                        }
                        Utils.startControl((ProxiedPlayer)player.get(), sender, proxyServer);
                    });
                } else {
                    invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NO_EXIST.color().replace("%prefix%", BungeeMessages.PREFIX.color())));
                }
            } else {
                invocation.sendMessage(TextComponent.fromLegacyText((String)BungeeMessages.NOT_ONLINE.color().replace("%prefix%", BungeeMessages.PREFIX.color()).replace("%player%", args[0])));
            }
        }
    }
}

