/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bungee;

import it.frafol.cleanss.bungee.Metrics;
import it.frafol.cleanss.bungee.UpdateCheck;
import it.frafol.cleanss.bungee.commands.ControlCommand;
import it.frafol.cleanss.bungee.commands.FinishCommand;
import it.frafol.cleanss.bungee.commands.ReloadCommand;
import it.frafol.cleanss.bungee.enums.BungeeConfig;
import it.frafol.cleanss.bungee.enums.BungeeMessages;
import it.frafol.cleanss.bungee.listeners.ChatListener;
import it.frafol.cleanss.bungee.listeners.CommandListener;
import it.frafol.cleanss.bungee.listeners.KickListener;
import it.frafol.cleanss.bungee.listeners.ServerListener;
import it.frafol.cleanss.bungee.objects.TextFile;
import java.util.Map;
import net.byteflux.libby.BungeeLibraryManager;
import net.byteflux.libby.Library;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.simpleyaml.configuration.file.YamlFile;

public class CleanSS
extends Plugin {
    private TextFile messagesTextFile;
    private TextFile configTextFile;
    private static CleanSS instance;

    public static CleanSS getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        this.loadLibraries();
        this.getLogger().info("\n\u00a7d   ___  __    ____    __    _  _    ___  ___\n  / __)(  )  ( ___)  /__\\  ( \\( )  / __)/ __)\n ( (__  )(__  )__)  /(__)\\  )  (   \\__ \\\\__ \\\n  \\___)(____)(____)(__)(__)(_)\\_)  (___/(___/\n");
        this.getLogger().info("\u00a77Loading \u00a7dconfiguration\u00a77...");
        this.loadFiles();
        this.getLogger().info("\u00a77Loading \u00a7dplugin\u00a77...");
        this.getProxy().registerChannel("cleanss:join");
        this.registerCommands();
        this.registerListeners();
        if (BungeeConfig.STATS.get(Boolean.class).booleanValue() && !this.getDescription().getVersion().contains("alpha")) {
            new Metrics(this, 17063);
            this.getLogger().info("\u00a77Metrics loaded \u00a7dsuccessfully\u00a77!");
        }
        this.UpdateChecker();
        this.getLogger().info("\u00a77Plugin \u00a7dsuccessfully \u00a77loaded!");
    }

    public YamlFile getConfigTextFile() {
        return CleanSS.getInstance().configTextFile.getConfig();
    }

    public YamlFile getMessagesTextFile() {
        return CleanSS.getInstance().messagesTextFile.getConfig();
    }

    private void registerCommands() {
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ControlCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new FinishCommand(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ReloadCommand());
    }

    private void loadFiles() {
        this.configTextFile = new TextFile(this.getDataFolder().toPath(), "config.yml");
        this.messagesTextFile = new TextFile(this.getDataFolder().toPath(), "messages.yml");
    }

    private void registerListeners() {
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ServerListener());
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new CommandListener());
        if (BungeeMessages.CONTROL_CHAT.get(Boolean.class).booleanValue()) {
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ChatListener(this));
        }
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new KickListener(this));
    }

    private void UpdateChecker() {
        if (!BungeeConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                this.getLogger().warning("\u00a7eThere is a new update available, download it on SpigotMC!");
            }
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) > Integer.parseInt(version.replace(".", ""))) {
                this.getLogger().warning("\u00a7eYou are using a development version, please report any bugs!");
            }
        });
    }

    public void UpdateChecker(ProxiedPlayer player) {
        if (!BungeeConfig.UPDATE_CHECK.get(Boolean.class).booleanValue()) {
            return;
        }
        new UpdateCheck(this).getVersion(version -> {
            if (Integer.parseInt(this.getDescription().getVersion().replace(".", "")) < Integer.parseInt(version.replace(".", ""))) {
                player.sendMessage(TextComponent.fromLegacyText((String)"\u00a7e[CleanScreenShare] There is a new update available, download it on SpigotMC!"));
            }
        });
    }

    private void loadLibraries() {
        BungeeLibraryManager bungeeLibraryManager = new BungeeLibraryManager(this);
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").build();
        bungeeLibraryManager.addJitPack();
        bungeeLibraryManager.loadLibrary(yaml);
    }

    public void onDisable() {
        this.getLogger().info("\u00a77Clearing \u00a7dinstances\u00a77...");
        instance = null;
        this.getProxy().unregisterChannel("cleanss:join");
        this.getLogger().info("\u00a77Plugin successfully \u00a7ddisabled\u00a77!");
    }

    public <K, V> K getKey(@NotNull Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public <K, V> V getValue(@NotNull Map<K, V> map, K key) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }
}

