/*
 * Decompiled with CFR 0.152.
 */
package it.frafol.cleanss.bukkit;

import it.frafol.cleanss.bukkit.commands.MainCommand;
import it.frafol.cleanss.bukkit.enums.SpigotConfig;
import it.frafol.cleanss.bukkit.listeners.PlayerListener;
import it.frafol.cleanss.bukkit.listeners.PluginMessageReceiver;
import it.frafol.cleanss.bukkit.listeners.WorldListener;
import it.frafol.cleanss.bukkit.objects.TextFile;
import net.byteflux.libby.BukkitLibraryManager;
import net.byteflux.libby.Library;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class CleanSS
extends JavaPlugin {
    private TextFile configTextFile;
    private TextFile cacheTextFile;
    public static CleanSS instance;

    public static CleanSS getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager((Plugin)this);
        Library yaml = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").build();
        bukkitLibraryManager.addJitPack();
        bukkitLibraryManager.loadLibrary(yaml);
        this.getLogger().info("\n   ___  __    ____    __    _  _   ___  ___\n  / __)(  )  ( ___)  /__\\  ( \\( ) / __)/ __)\n ( (__  )(__  )__)  /(__)\\  )  (  \\__ \\\\__ \\\n  \\___)(____)(____)(__)(__)(_)\\_) (___/(___/\n");
        this.getLogger().info("Server version: " + Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3] + ".");
        if (this.getSuperLegacy()) {
            this.getLogger().severe("Support for your version was declined.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Loading configuration...");
        this.configTextFile = new TextFile(this.getDataFolder().toPath(), "settings.yml");
        this.cacheTextFile = new TextFile(this.getDataFolder().toPath(), "cache_do_not_touch.yml");
        this.getLogger().info("Loading channels...");
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "cleanss:join", (PluginMessageListener)new PluginMessageReceiver());
        this.getLogger().info("Loading listeners...");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new MainCommand(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        this.getLogger().info("Successfully loaded!");
        if (SpigotConfig.DAY_CYCLE.get(Boolean.class).booleanValue()) {
            for (World worlds : this.getServer().getWorlds()) {
                worlds.setGameRuleValue("doDaylightCycle", "false");
            }
        }
    }

    public void onDisable() {
        instance = null;
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this, "cleanss:join");
        this.getServer().getMessenger().unregisterIncomingPluginChannel((Plugin)this, "cleanss:reload");
        this.getLogger().info("Successfully disabled!");
    }

    public TextFile getConfigTextFile() {
        return this.configTextFile;
    }

    public TextFile getCacheTextFile() {
        return this.cacheTextFile;
    }

    public boolean getSuperLegacy() {
        return Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_6_R") || Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_5_R") || Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_4_R") || Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_3_R") || Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_2_R") || Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_1_R") || Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].contains("1_0_R");
    }
}

