/*
 * Decompiled with CFR 0.152.
 */
package creaparty.fun;

import creaparty.fun.AFKCommand;
import creaparty.fun.CreativeModeCommand;
import creaparty.fun.FlyCommand;
import creaparty.fun.InvincibilityCommand;
import creaparty.fun.InvisibilityCommand;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FUN
extends JavaPlugin
implements CommandExecutor,
Listener {
    private InvisibilityCommand invisibilityCommand;
    private InvincibilityCommand invincibilityCommand;
    private CreativeModeCommand creativeModeCommand;
    private FlyCommand flyCommand;
    private AFKCommand afkCommand;

    public void onEnable() {
        this.invisibilityCommand = new InvisibilityCommand();
        this.invincibilityCommand = new InvincibilityCommand();
        this.creativeModeCommand = new CreativeModeCommand();
        this.flyCommand = new FlyCommand();
        this.afkCommand = new AFKCommand();
        this.getCommand("creaparty").setExecutor((CommandExecutor)this);
        this.getCommand("creafun").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be run by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("creaparty")) {
            return this.creativeModeCommand.execute(player);
        }
        if (command.getName().equalsIgnoreCase("creafun")) {
            if (args.length != 2) {
                player.sendMessage("Usage: /creafun weather <clear|rain|thunder>");
                player.sendMessage("Usage: /creafun <invisible|invincible|fly|afk>");
                return true;
            }
            if (args[0].equalsIgnoreCase("weather")) {
                World world = player.getWorld();
                switch (args[1].toLowerCase()) {
                    case "clear": {
                        world.setStorm(false);
                        world.setThundering(false);
                        player.sendMessage("The weather has been set to clear.");
                        return true;
                    }
                    case "rain": {
                        world.setStorm(true);
                        world.setThundering(false);
                        player.sendMessage("The weather has been set to rain.");
                        return true;
                    }
                    case "thunder": {
                        world.setStorm(true);
                        world.setThundering(true);
                        player.sendMessage("The weather has been set to thunder.");
                        return true;
                    }
                }
                player.sendMessage("Usage: /creafun weather <clear|rain|thunder>");
                return true;
            }
            if (args[0].equalsIgnoreCase("invisible")) {
                return this.invisibilityCommand.execute(player);
            }
            if (args[0].equalsIgnoreCase("invincible")) {
                return this.invincibilityCommand.execute(player);
            }
            if (args[0].equalsIgnoreCase("fly")) {
                if (args[1].equalsIgnoreCase("on")) {
                    return this.flyCommand.execute(player, true);
                }
                if (args[1].equalsIgnoreCase("off")) {
                    return this.flyCommand.execute(player, false);
                }
                player.sendMessage("Usage: /creafun fly <on|off>");
                return true;
            }
            if (args[0].equalsIgnoreCase("afk")) {
                return this.afkCommand.execute(player);
            }
            player.sendMessage("Usage: /creafun <invisible|invincible|weather|fly|afk>");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.invincibilityCommand.isInvincible(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp() && player.getGameMode() == GameMode.CREATIVE) {
            player.setGameMode(GameMode.SURVIVAL);
            player.setGravity(true);
        }
        player.setInvulnerable(false);
        this.invisibilityCommand.setVisible(player);
        this.invincibilityCommand.setVincible(player);
        player.setFlySpeed(0.05f);
        player.setWalkSpeed(0.2f);
        this.flyCommand.setFlying(player, true);
        player.setFlying(false);
    }
}

