/*
 * Decompiled with CFR 0.152.
 */
package creaparty.fun;

import creaparty.fun.Configuration;
import creaparty.fun.DataConfiguration;
import creaparty.fun.FUN;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

class CreativeModeCommand {
    private final Configuration config = new Configuration(FUN.getPlugin(FUN.class));
    private final DataConfiguration dataConfig = new DataConfiguration(((FUN)FUN.getPlugin(FUN.class)).getDataFolder());

    public boolean execute(final Player player) {
        this.config.load();
        if (this.dataConfig.contains(player.getName())) {
            long timestamp = this.dataConfig.getTimestamp(player.getName());
            if (System.currentTimeMillis() / 1000L - timestamp >= this.config.getCooldown()) {
                this.dataConfig.remove(player.getName());
            } else {
                player.sendMessage(this.config.getCooldownMessage());
                return true;
            }
        }
        if (!player.hasPermission("creaparty.group") || !player.hasPermission("creaparty.artefact.fun")) {
            player.sendMessage(this.config.getPermissionMessage());
            return true;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            player.sendMessage("You are already in creative mode.");
            return true;
        }
        int remaining = this.config.getPlayerRemaining(player);
        if (remaining > 0) {
            player.sendMessage("You have " + remaining + " minutes left in creative mode.");
            return true;
        }
        final GameMode previousGameMode = player.getGameMode();
        player.setGameMode(GameMode.CREATIVE);
        this.dataConfig.set(player.getName(), System.currentTimeMillis() / 1000L);
        this.dataConfig.save();
        this.config.setPlayerRemaining(player, this.config.getTimeLimit());
        player.sendMessage(this.config.getEnterMessage().replace("%time%", String.valueOf(this.config.getTimeLimit())));
        new BukkitRunnable(){
            int timeLeft;
            long timestamp;
            {
                this.timeLeft = CreativeModeCommand.this.config.getTimeLimit();
                this.timestamp = CreativeModeCommand.this.dataConfig.getTimestamp(player.getName());
            }

            public void run() {
                CreativeModeCommand.this.config.setPlayerRemaining(player, this.timeLeft);
                if (System.currentTimeMillis() / 1000L - this.timestamp >= CreativeModeCommand.this.config.getCooldown()) {
                    CreativeModeCommand.this.dataConfig.remove(player.getName());
                    CreativeModeCommand.this.dataConfig.save();
                }
                player.sendMessage(CreativeModeCommand.this.config.getWarningMessage().replace("%time%", String.valueOf(this.timeLeft)));
                if (this.timeLeft <= 0) {
                    player.setGameMode(previousGameMode);
                    CreativeModeCommand.this.config.removePlayer(player);
                    player.sendMessage(CreativeModeCommand.this.config.getLeaveMessage());
                    this.cancel();
                } else {
                    --this.timeLeft;
                }
            }
        }.runTaskTimer((Plugin)FUN.getPlugin(FUN.class), 0L, 1200L);
        return true;
    }
}

