/*
 * Decompiled with CFR 0.152.
 */
package creaparty.fun;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Configuration {
    private static final String TIME_LIMIT_CONFIG_KEY = "time_limit";
    private static final int DEFAULT_TIME_LIMIT = 35;
    private static final String COOLDOWN_CONFIG_KEY = "cooldown";
    private static final long DEFAULT_COOLDOWN = 3600L;
    private static final String ENTER_MESSAGE_CONFIG_KEY = "enter_message";
    private static final String DEFAULT_ENTER_MESSAGE = "You have been put in creative mode for %time% minutes.";
    private static final String LEAVE_MESSAGE_CONFIG_KEY = "leave_message";
    private static final String DEFAULT_LEAVE_MESSAGE = "Your creative mode time is up.";
    private static final String COOLDOWN_MESSAGE_CONFIG_KEY = "cooldown_message";
    private static final String DEFAULT_COOLDOWN_MESSAGE = "You must wait 1 hour before using this command again.";
    private static final String PERMISSION_MESSAGE_CONFIG_KEY = "permission_message";
    private static final String DEFAULT_PERMISSION_MESSAGE = "You do not have permission to use this command.";
    private static final String WARNING_MESSAGE_CONFIG_KEY = "warning_message";
    private static final String DEFAULT_WARNING_MESSAGE = "Time left in creative mode: %time% minutes.";
    private final JavaPlugin plugin;
    private final File configFile;
    private final FileConfiguration config;
    private final Map<Player, Integer> playerRemaining;

    public Configuration(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.playerRemaining = new HashMap<Player, Integer>();
    }

    public void load() {
        if (!this.configFile.exists()) {
            this.plugin.saveDefaultConfig();
        }
    }

    public void save() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getTimeLimit() {
        return this.config.getInt(TIME_LIMIT_CONFIG_KEY, 35);
    }

    public String getWarningMessage() {
        return this.config.getString(WARNING_MESSAGE_CONFIG_KEY, DEFAULT_WARNING_MESSAGE);
    }

    public void setTimeLimit(int timeLimit) {
        this.config.set(TIME_LIMIT_CONFIG_KEY, (Object)timeLimit);
        this.save();
    }

    public long getCooldown() {
        return this.config.getLong(COOLDOWN_CONFIG_KEY, 3600L);
    }

    public void setCooldown(long cooldown) {
        this.config.set(COOLDOWN_CONFIG_KEY, (Object)cooldown);
        this.save();
    }

    public String getEnterMessage() {
        return this.config.getString(ENTER_MESSAGE_CONFIG_KEY, DEFAULT_ENTER_MESSAGE);
    }

    public void setEnterMessage(String message) {
        this.config.set(ENTER_MESSAGE_CONFIG_KEY, (Object)message);
        this.save();
    }

    public String getLeaveMessage() {
        return this.config.getString(LEAVE_MESSAGE_CONFIG_KEY, DEFAULT_LEAVE_MESSAGE);
    }

    public void setLeaveMessage(String message) {
        this.config.set(LEAVE_MESSAGE_CONFIG_KEY, (Object)message);
        this.save();
    }

    public String getCooldownMessage() {
        return this.config.getString(COOLDOWN_MESSAGE_CONFIG_KEY, DEFAULT_COOLDOWN_MESSAGE);
    }

    public void setCooldownMessage(String message) {
        this.config.set(COOLDOWN_MESSAGE_CONFIG_KEY, (Object)message);
        this.save();
    }

    public String getPermissionMessage() {
        return this.config.getString(PERMISSION_MESSAGE_CONFIG_KEY, DEFAULT_PERMISSION_MESSAGE);
    }

    public void setPermissionMessage(String message) {
        this.config.set(PERMISSION_MESSAGE_CONFIG_KEY, (Object)message);
        this.save();
    }

    public void setPlayerRemaining(Player player, int remaining) {
        this.playerRemaining.put(player, remaining);
    }

    public int getPlayerRemaining(Player player) {
        if (this.playerRemaining.containsKey(player)) {
            return this.playerRemaining.get(player);
        }
        return 0;
    }

    public void removePlayer(Player player) {
        this.playerRemaining.remove(player);
    }
}

