/*
 * Decompiled with CFR 0.152.
 */
package it.ohalee.minecraftgpt.handler;

import it.ohalee.minecraftgpt.Main;
import it.ohalee.minecraftgpt.OpenAI;
import it.ohalee.minecraftgpt.Type;
import it.ohalee.minecraftgpt.util.Messages;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatHandler
implements Listener {
    private final Main plugin;

    @EventHandler
    public void onAsyncPlayerChat(AsyncPlayerChatEvent e) {
        StringBuilder builder;
        Player player = e.getPlayer();
        boolean hasFull = Main.USER_TYPE.asMap().values().stream().anyMatch(type -> type == Type.FULL);
        if (!Main.CACHE.asMap().containsKey(player) && !hasFull) {
            return;
        }
        Collection<Object> recipients = switch (Main.USER_TYPE.asMap().getOrDefault(player, hasFull ? Type.FULL : Type.SINGLE)) {
            default -> throw new IncompatibleClassChangeError();
            case Type.SINGLE -> Collections.singletonList(player);
            case Type.FULL, Type.BROADCAST -> e.getRecipients();
        };
        List list = this.plugin.getConfig().getStringList("format");
        if (!this.plugin.getConfig().getBoolean("use-default-chat", false)) {
            e.setCancelled(true);
            this.sendMessage(this.format((String)list.get(0), e.getMessage(), player.getName()), recipients);
        }
        if ((builder = (StringBuilder)Main.CACHE.getIfPresent((Object)player)) == null) {
            builder = new StringBuilder();
        }
        OpenAI.getResponse(this.plugin.getConfig().getConfigurationSection("chatgpt"), builder, e.getMessage()).whenComplete((response, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                player.sendMessage(Messages.format(this.plugin.getConfig().getString("command.error")));
                return;
            }
            this.sendMessage(this.format((String)list.get(1), (String)response, player.getName()), recipients);
        });
    }

    private String format(String str, String message, String player) {
        return Messages.format(str).replace("%message%", message).replace("%player%", player);
    }

    private void sendMessage(String message, Collection<Player> players) {
        for (Player player : players) {
            player.sendMessage(message);
        }
        if (this.plugin.getConfig().getBoolean("send-messages-to-console", true)) {
            this.plugin.getServer().getConsoleSender().sendMessage(message);
        }
    }

    public ChatHandler(Main plugin) {
        this.plugin = plugin;
    }
}

